package com.sap.cds.generator.util;

import java.time.Instant;

import com.sap.cds.generator.Configuration;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec.Builder;

public class GeneratedAnnotationUtil {
	// This should be changed to javax.annotation.processing for the 2.x release
	private static final String GENERATED_PACKAGE_NAME = "javax.annotation.processing";
	private static final String GENERATED_CLASS_NAME = "Generated";

	private final Configuration cfg;
	private final AnnotationSpec annotation;

	public GeneratedAnnotationUtil(Configuration cfg) {
		this.cfg = cfg;
		ClassName className = ClassName.get(GENERATED_PACKAGE_NAME, GENERATED_CLASS_NAME);
		annotation = AnnotationSpec
				.builder(className)
				.addMember("value", "$S", "cds-maven-plugin")
				.addMember("date", "$S", Instant.now().toString())
				.addMember("comments", "$S", cfg.getPluginInformation())
				.build();
	}

	public AnnotationSpec getGeneratedAnnotation() {
		return annotation;
	}

	public void addTo(Builder builder) {
		if (cfg.getGeneratedAnnotation()) {
			builder.addAnnotation(annotation);
		}
	}
}
