/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.util;

public class PatternMatcher {
    private static final String DOT = "\\.";
    private static final String CHAR = "[^\\.]";
    private static final String CHARS = PatternMatcher.many("[^\\.]");
    private static final String PATH = CHARS + "\\.";
    private static final String PATHS = PatternMatcher.many(PATH);
    private String regex;

    private PatternMatcher(String regex) {
        this.regex = regex;
    }

    public static PatternMatcher create(String pattern) {
        return new PatternMatcher(PatternMatcher.transformPattern(pattern));
    }

    private static String transformPattern(String pattern) {
        if (pattern.endsWith("**")) {
            pattern = pattern + ".*";
        }
        char[] chars = pattern.toCharArray();
        int length = pattern.length();
        StringBuilder regex = new StringBuilder("");
        block4: for (int i = 0; i < length; ++i) {
            char c = chars[i];
            switch (c) {
                case '.': {
                    regex.append(DOT);
                    continue block4;
                }
                case '*': {
                    if (pattern.indexOf("**.", i) == i) {
                        regex.append(PATHS);
                        i += 2;
                        continue block4;
                    }
                    regex.append(CHARS);
                    continue block4;
                }
                default: {
                    regex.append(c);
                }
            }
        }
        regex.append("$");
        return regex.toString();
    }

    public boolean matches(String qualifiedName) {
        return qualifiedName.matches(this.regex);
    }

    private static String many(String pattern) {
        return "(" + pattern + ")*";
    }
}

