/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator;

import com.google.common.collect.Lists;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.GeneratedFile;
import com.sap.cds.generator.util.GeneratorMode;
import com.sap.cds.generator.util.ParserMode;
import com.sap.cds.generator.writer.ModelWriter;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.CdsModelReader;
import com.sap.cds.reflect.impl.reader.issuecollector.Issue;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollector;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollectorFactory;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueType;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cds4jCodegen {
    private static final Logger logger = LoggerFactory.getLogger(Cds4jCodegen.class);
    private static final IssueCollector issueCollector = IssueCollectorFactory.getIssueCollector(Cds4jCodegen.class);
    private final Configuration cfg;

    public Cds4jCodegen(Configuration cfg) {
        this.cfg = cfg;
    }

    public Result generate(CsnSupplier csn, GeneratedFile.Consumer consumer) throws IOException {
        IssueCollectorFactory.clearIssues();
        Result result = new Result();
        try {
            CdsModel cdsModel = CdsModelReader.read((byte[])csn.get());
            result.status = this.generate(cdsModel, consumer);
        }
        catch (NoSuchFileException e) {
            String msg = "CSN file not found: ";
            logger.debug(msg, (Throwable)e);
            issueCollector.critical("", msg + e.getFile(), new Object[0]);
        }
        catch (Throwable t) {
            logger.debug("Stopped execution due to exception: ", t);
            issueCollector.critical("", t.getMessage(), new Object[0]);
        }
        result.issues.addAll(IssueCollectorFactory.getIssues());
        return result;
    }

    private Result.Status generate(CdsModel cdsModel, GeneratedFile.Consumer consumer) {
        if (Cds4jCodegen.noRelevantIssues(this.cfg.getParserMode(), this.cfg.getGeneratorMode())) {
            ModelWriter visitor = new ModelWriter(consumer, this.cfg, cdsModel);
            cdsModel.accept((CdsVisitor)visitor);
            return Result.Status.SUCCESS;
        }
        return Result.Status.FAILURE;
    }

    protected static boolean noRelevantIssues(ParserMode parserMode, GeneratorMode generatorMode) {
        if (IssueCollectorFactory.hasIssues((IssueType)IssueType.CRITICAL)) {
            return false;
        }
        if (parserMode == ParserMode.STRICT && IssueCollectorFactory.hasIssues((IssueType)IssueType.UNRECOGNIZED)) {
            return false;
        }
        if (generatorMode == GeneratorMode.STRICT) {
            if (IssueCollectorFactory.hasIssues((IssueType)IssueType.ERROR)) {
                return false;
            }
            if (IssueCollectorFactory.hasIssues((IssueType)IssueType.UNSUPPORTED)) {
                return false;
            }
        }
        return true;
    }

    public static class Result {
        final Collection<Issue> issues = Lists.newLinkedList();
        Status status = Status.FAILURE;

        public Status getStatus() {
            return this.status;
        }

        public Collection<Issue> getIssues() {
            return Collections.unmodifiableCollection(this.issues);
        }

        public static enum Status {
            SUCCESS,
            FAILURE;

        }
    }

    @FunctionalInterface
    public static interface CsnSupplier {
        public byte[] get() throws IOException;
    }
}

