/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.util;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.sap.cds.generator.writer.CaseFormatHelper;
import java.util.Locale;
import javax.lang.model.SourceVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamesUtils {
    private static final Logger logger = LoggerFactory.getLogger(NamesUtils.class);

    private NamesUtils() {
    }

    public static String javaPackage(String basePackage, String qualifiedName) {
        String packageName = NamesUtils.namespace(qualifiedName);
        if (!Strings.isNullOrEmpty((String)basePackage)) {
            packageName = Joiner.on((char)'.').skipNulls().join((Object)basePackage, (Object)packageName, new Object[0]);
        }
        if (Strings.isNullOrEmpty((String)packageName)) {
            packageName = "model";
        }
        return packageName.toLowerCase(Locale.US);
    }

    public static String namespace(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            return qualifiedName.substring(0, lastDot);
        }
        return null;
    }

    public static String unqualifiedName(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        return qualifiedName.substring(lastDot + 1);
    }

    public static String unqualifiedContextName(String qualifiedName) {
        if (qualifiedName.contains(".")) {
            String[] bits = qualifiedName.split("\\.");
            return bits[bits.length - 2];
        }
        return "CdsModel";
    }

    public static String qualifiedJavaClass(String basePackage, String entityName) {
        String packageName = NamesUtils.javaPackage(basePackage, entityName);
        String name = NamesUtils.unqualifiedName(entityName);
        return packageName + "." + CaseFormatHelper.toUpperCamel(name);
    }

    public static void checkForJavaKeyword(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            String[] split;
            for (String word : split = qualifiedName.split("\\.")) {
                if (!SourceVersion.isKeyword(word)) continue;
                logger.warn("The Entity " + qualifiedName + " contains a reserved Java keyword in its fully qualified name.");
            }
        }
    }
}

