/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.MethodStyle;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.PoetTypeName;
import com.sap.cds.generator.writer.CaseFormatHelper;
import com.sap.cds.ql.CdsName;
import com.sap.cds.ql.impl.CdsModelUtils;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateConsumptionInterfaceVisitor
implements CdsVisitor {
    private static final Logger logger = LoggerFactory.getLogger(CreateConsumptionInterfaceVisitor.class);
    private static final ParameterizedTypeName MAP_STR2OBJ = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), WildcardTypeName.subtypeOf(Object.class)});
    private final TypeSpec.Builder builder;
    private final Configuration cfg;
    private final String typeName;

    public static CdsVisitor create(TypeSpec.Builder builder, Configuration config, String typeName) {
        return new CreateConsumptionInterfaceVisitor(builder, config, typeName);
    }

    private CreateConsumptionInterfaceVisitor(TypeSpec.Builder builder, Configuration config, String typeName) {
        this.builder = builder;
        this.cfg = config;
        this.typeName = NamesUtils.qualifiedJavaClass(this.cfg.getBasePackage(), typeName);
        this.builder.addSuperinterface(CdsData.class);
    }

    public void visit(CdsEntity entity) {
        this.addStaticProxyMethod((CdsDefinition)entity);
        this.builder.addAnnotation(CreateConsumptionInterfaceVisitor.cdsNameAnnotation(entity.getQualifiedName(), "$S"));
    }

    public void visit(CdsEvent event) {
        this.addStaticProxyMethod((CdsDefinition)event);
        this.builder.addAnnotation(CreateConsumptionInterfaceVisitor.cdsNameAnnotation(event.getQualifiedName(), "$S"));
    }

    public void visit(CdsStructuredType struct) {
        this.builder.addAnnotation(CreateConsumptionInterfaceVisitor.cdsNameAnnotation(struct.getQualifiedName(), "$S"));
    }

    private void addStaticProxyMethod(CdsDefinition entity) {
        TypeName returnType = PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(entity.getName()));
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"create").returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        codeBuilder.addStatement("return $T.create($T.class)", new Object[]{ClassName.get(Struct.class), returnType});
        methodBuilder.addCode(codeBuilder.build());
        this.builder.addMethod(methodBuilder.build());
    }

    private static AnnotationSpec cdsNameAnnotation(String cdsName, String format) {
        return AnnotationSpec.builder(CdsName.class).addMember("value", format, new Object[]{cdsName}).build();
    }

    public void visit(CdsElement element) {
        this.addStaticAttribute(element);
        this.addGetter(element);
        this.addSetter(element);
    }

    private void addSetter(CdsElement attribute) {
        String setter;
        TypeName returnType;
        TypeName paramType = this.getSetterParam(attribute);
        if (paramType == null) {
            return;
        }
        if (this.cfg.getMethodStyle() == MethodStyle.BEAN) {
            returnType = TypeName.VOID;
            setter = "set" + CaseFormatHelper.toUpperCamel(attribute.getName());
        } else {
            returnType = PoetTypeName.getTypeName(this.typeName);
            setter = CaseFormatHelper.toLowerCamel(attribute.getName());
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)setter).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(paramType, CaseFormatHelper.toLowerCamel(attribute.getName()), new Modifier[0]);
        CreateConsumptionInterfaceVisitor.addCdsNameAnnotation(methodBuilder, attribute.getName(), setter);
        this.builder.addMethod(methodBuilder.build());
    }

    private TypeName getSetterParam(CdsElement element) {
        if (element.getType().isAssociation()) {
            if (CdsModelUtils.isSingleValued((CdsType)element.getType())) {
                return MAP_STR2OBJ;
            }
            return CreateConsumptionInterfaceVisitor.listOf((TypeName)WildcardTypeName.subtypeOf((TypeName)MAP_STR2OBJ));
        }
        return this.getAttributeType(element.getType());
    }

    private TypeName getAttributeType(CdsType type) {
        TypeName attributeType;
        if (type.isAssociation()) {
            String targetName = ((CdsAssociationType)type.as(CdsAssociationType.class)).getTarget().getQualifiedName();
            attributeType = PoetTypeName.getTypeFromCdsName(this.cfg.getBasePackage(), targetName);
            if (!CdsModelUtils.isSingleValued((CdsType)type)) {
                attributeType = CreateConsumptionInterfaceVisitor.listOf(attributeType);
            }
        } else if (type.isSimple()) {
            attributeType = PoetTypeName.getTypeName(((CdsSimpleType)type.as(CdsSimpleType.class)).getJavaType().getTypeName());
        } else if (type.isStructured()) {
            String targetName = type.getQualifiedName();
            attributeType = PoetTypeName.getTypeFromCdsName(this.cfg.getBasePackage(), targetName);
        } else {
            logger.warn("Consumption Interface Generation: Unsupported CDS Element with attribute name '" + type.getName() + "' and type '" + type + "'");
            return null;
        }
        return attributeType;
    }

    private static ParameterizedTypeName listOf(TypeName type) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{type});
    }

    private void addGetter(CdsElement attribute) {
        TypeName returnType = this.getAttributeType(attribute.getType());
        if (returnType == null) {
            return;
        }
        String getter = this.cfg.getMethodStyle().equals((Object)MethodStyle.BEAN) ? "get" + CaseFormatHelper.toUpperCamel(attribute.getName()) : CaseFormatHelper.toLowerCamel(attribute.getName());
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)getter).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        CreateConsumptionInterfaceVisitor.addCdsNameAnnotation(methodBuilder, attribute.getName(), getter);
        this.builder.addMethod(methodBuilder.build());
    }

    private static MethodSpec.Builder addCdsNameAnnotation(MethodSpec.Builder builder, String cdsName, String javaName) {
        if (!cdsName.equals(CreateConsumptionInterfaceVisitor.propertyName(javaName))) {
            builder.addAnnotation(CreateConsumptionInterfaceVisitor.cdsNameAnnotation(CaseFormatHelper.toUpperUnderscore(cdsName), "$L"));
        }
        return builder;
    }

    private static String propertyName(String javaName) {
        if (javaName.startsWith("set") || javaName.startsWith("get")) {
            javaName = CaseFormatHelper.lowercaseFirst(javaName.substring(3));
        }
        return javaName;
    }

    private void addStaticAttribute(CdsElement attribute) {
        String name = CaseFormatHelper.toUpperUnderscore(attribute.getName());
        FieldSpec staticField = FieldSpec.builder(String.class, (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{attribute.getName()}).build();
        this.builder.addField(staticField);
    }
}

