/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.PoetTypeName;
import com.sap.cds.generator.writer.CaseFormatHelper;
import com.sap.cds.ql.CdsName;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class WrapperInterfaceCreator {
    private final TypeSpec.Builder builder;
    private final CdsModel model;
    private final Configuration cfg;

    public static WrapperInterfaceCreator create(TypeSpec.Builder builder, CdsModel model, Configuration cfg) {
        return new WrapperInterfaceCreator(builder, model, cfg);
    }

    private WrapperInterfaceCreator(TypeSpec.Builder builder, CdsModel model, Configuration cfg) {
        this.builder = builder;
        this.model = model;
        this.cfg = cfg;
    }

    public boolean generateInterface(String context) {
        List<CdsEntity> entityList = this.getEntities(context);
        if (entityList.isEmpty()) {
            return false;
        }
        if (context != null) {
            this.builder.addAnnotation(AnnotationSpec.builder(CdsName.class).addMember("value", "$S", new Object[]{context}).build());
            this.addStaticQualifiedAttribute(context);
        }
        entityList.stream().forEach(e -> {
            String interfaceName = NamesUtils.qualifiedJavaClass(this.cfg.getBasePackage(), e.getQualifiedName()) + this.cfg.getClassNameSuffix();
            ParameterizedTypeName type = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{PoetTypeName.getTypeName(interfaceName)});
            FieldSpec staticField = FieldSpec.builder((TypeName)type, (String)CaseFormatHelper.toUpperUnderscore(e.getName()), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("$N.class", new Object[]{NamesUtils.unqualifiedName(interfaceName)}).build();
            this.builder.addField(staticField);
        });
        return true;
    }

    private void addStaticQualifiedAttribute(String context) {
        FieldSpec staticEntityField = FieldSpec.builder(String.class, (String)"CDS_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{context}).build();
        this.builder.addField(staticEntityField);
    }

    private List<CdsEntity> getEntities(String context) {
        if (context == null) {
            return this.model.concreteEntities().filter(e -> !e.getQualifiedName().contains(".")).collect(Collectors.toList());
        }
        return this.model.concreteEntities().filter(e -> this.filterEntites(context, (CdsEntity)e)).collect(Collectors.toList());
    }

    private boolean filterEntites(String context, CdsEntity entity) {
        String qualifiedName = entity.getQualifiedName();
        if (qualifiedName.contains(".")) {
            String entityContextPath = qualifiedName.substring(0, qualifiedName.lastIndexOf(46));
            return entityContextPath.equalsIgnoreCase(context);
        }
        return true;
    }
}

