/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.util;

import com.sap.cds.generator.util.FileLocation;
import com.sap.cds.generator.util.GeneratedFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;

public class FileSystem
implements GeneratedFile.Accessor {
    private final Path baseDirectory;
    private boolean mavenLayout;

    public FileSystem(Path baseDirectory, boolean mavenLayout) {
        this.mavenLayout = mavenLayout;
        File dir = baseDirectory.toFile();
        if (dir.exists() && !dir.isDirectory()) {
            String message = String.format("'%s' is not a directory.", baseDirectory.getFileName());
            throw new IllegalArgumentException(message);
        }
        this.baseDirectory = baseDirectory;
    }

    @Override
    public void accept(GeneratedFile file) throws IOException {
        block16: {
            try {
                Path outputPath = this.getPath(file);
                if (Files.exists(outputPath, new LinkOption[0])) {
                    try (SeekableByteChannel rbc = Files.newByteChannel(outputPath, new OpenOption[0]);
                         InputStream in = Channels.newInputStream(rbc);){
                        if (!IOUtils.contentEquals((InputStream)file.getContent(), (InputStream)in)) {
                            Files.copy(file.getContent(), outputPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        break block16;
                    }
                }
                Files.createDirectories(outputPath.toFile().getParentFile().toPath(), new FileAttribute[0]);
                Files.copy(file.getContent(), outputPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                String message = String.format("Error writing file '%s' to file system.", file.getUri());
                throw new IOException(message, e);
            }
        }
    }

    private Path getPath(FileLocation location) {
        Path base = this.getBase(location);
        Path outputPath = base.resolve(location.getUri().getPath());
        return outputPath;
    }

    private Path getBase(FileLocation location) {
        if (!this.mavenLayout) {
            return this.baseDirectory;
        }
        return this.baseDirectory.resolve(location.isResource() ? "resources" : "java");
    }

    @Override
    public GeneratedFile get(final FileLocation location) throws IOException {
        final Path path = this.getPath(location);
        return new GeneratedFile(){

            @Override
            public URI getUri() {
                return location.getUri();
            }

            @Override
            public InputStream getContent() throws IOException {
                if (!path.toFile().exists()) {
                    return null;
                }
                return Files.newInputStream(path, new OpenOption[0]);
            }
        };
    }
}

