/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.sap.cds.generator.Cds4jCodegen;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.PoetTypeName;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.writer.CaseFormatHelper;
import com.sap.cds.generator.writer.ModelWriter;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.generator.writer.Types;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsBoundAction;
import com.sap.cds.reflect.CdsBoundFunction;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsOperation;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.reader.model.CdsConstants;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public class CreateAppServiceInterfaceVisitor
implements CdsVisitor {
    private static final String DOT_CDS_NAME = ".CDS_NAME";
    private static final String DRAFT_SUFFIX = "_drafts";
    private static final ClassName INNER_DRAFT = ClassName.get((String)"", (String)"Draft", (String[])new String[0]);
    private static final ClassName INNER_APPLICATION = ClassName.get((String)"", (String)"Application", (String[])new String[0]);
    private static final ClassName INNER_REMOTE = ClassName.get((String)"", (String)"Remote", (String[])new String[0]);
    private final TypeSpec.Builder builder;
    private final Configuration config;
    private final NamesUtils namesUtils;
    private final ClassName interfaceName;

    CreateAppServiceInterfaceVisitor(TypeSpec.Builder builder, ClassName interfaceName, ModelWriter.Context context) {
        this.builder = builder;
        this.interfaceName = interfaceName;
        this.config = context.config();
        this.namesUtils = context.namesUtils();
    }

    public void visit(CdsService service) {
        if (this.namesUtils.isExcluded(service.getQualifiedName()) || Cds4jCodegen.isIgnored((CdsDefinition)service)) {
            return;
        }
        NamesUtils.checkForJavaKeyword(service.getQualifiedName());
        this.builder.addSuperinterface((TypeName)Types.CQN_SERVICE);
        String cdsNameValue = TypeUtils.builderClassName((CdsDefinition)service).simpleName() + DOT_CDS_NAME;
        this.builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(cdsNameValue, "$L"));
        this.addInnerInterface(INNER_APPLICATION, new ClassName[]{Types.APPLICATION_SERVICE, this.interfaceName});
        this.addInnerInterface(INNER_REMOTE, new ClassName[]{Types.REMOTE_SERVICE, this.interfaceName});
        if (CreateAppServiceInterfaceVisitor.isServiceDraftEnabled(service)) {
            this.addInnerInterface(INNER_DRAFT, new ClassName[]{Types.DRAFT_SERVICE, this.interfaceName});
        }
        service.entities().forEach(entity -> entity.accept((CdsVisitor)this));
        service.actions().forEach(action -> action.accept((CdsVisitor)this));
        service.functions().forEach(function -> function.accept((CdsVisitor)this));
    }

    private void addInnerInterface(ClassName innerInterfaceName, ClassName[] superInterfaces) {
        TypeSpec.Builder innerInterfaceBuilder = TypeSpec.interfaceBuilder((ClassName)innerInterfaceName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        List.of(superInterfaces).forEach(arg_0 -> ((TypeSpec.Builder)innerInterfaceBuilder).addSuperinterface(arg_0));
        this.builder.addType(innerInterfaceBuilder.build());
    }

    public void visit(CdsEntity entity) {
        if (entity.getName().endsWith(DRAFT_SUFFIX) || this.namesUtils.isExcluded(entity.getQualifiedName()) || Cds4jCodegen.isIgnored((CdsDefinition)entity)) {
            return;
        }
        NamesUtils.checkForJavaKeyword(entity.getQualifiedName());
        entity.actions().forEach(action -> {
            if (CdsConstants.DRAFT_ACTIONS.contains(action.getName())) {
                return;
            }
            Optional<MethodSpec> method = this.buildOperationFacadeMethod((CdsOperation)action, action.returnType(), Optional.of(entity));
            method.ifPresent(arg_0 -> ((TypeSpec.Builder)this.builder).addMethod(arg_0));
        });
        entity.functions().forEach(function -> {
            Optional<MethodSpec> method = this.buildOperationFacadeMethod((CdsOperation)function, function.returnType(), Optional.of(entity));
            method.ifPresent(arg_0 -> ((TypeSpec.Builder)this.builder).addMethod(arg_0));
        });
    }

    public void visit(CdsFunction function) {
        if (this.namesUtils.isExcluded(function.getQualifiedName()) || Cds4jCodegen.isIgnored((CdsDefinition)function)) {
            return;
        }
        Optional<MethodSpec> method = this.buildOperationFacadeMethod((CdsOperation)function, function.returnType(), Optional.empty());
        method.ifPresent(arg_0 -> ((TypeSpec.Builder)this.builder).addMethod(arg_0));
    }

    public void visit(CdsAction action) {
        if (this.namesUtils.isExcluded(action.getQualifiedName()) || Cds4jCodegen.isIgnored((CdsDefinition)action)) {
            return;
        }
        Optional<MethodSpec> method = this.buildOperationFacadeMethod((CdsOperation)action, action.returnType(), Optional.empty());
        method.ifPresent(arg_0 -> ((TypeSpec.Builder)this.builder).addMethod(arg_0));
    }

    private Optional<MethodSpec> buildOperationFacadeMethod(CdsOperation operation, Optional<CdsType> cdsReturnType, Optional<CdsEntity> entityOpt) {
        NamesUtils.checkForJavaKeyword(operation.getQualifiedName());
        Optional<String> methodName = NamesUtils.getNameIfNotIgnored((CdsAnnotatable)operation, operation.getName());
        if (methodName.isEmpty()) {
            return Optional.empty();
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)this.namesUtils.validJavaMethodName(methodName.get())).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        ClassName eventContextClassName = TypeUtils.eventContextClassName((CdsDefinition)operation, entityOpt.orElse(null), this.config);
        methodBuilder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(eventContextClassName.simpleName() + DOT_CDS_NAME, "$L"));
        if (cdsReturnType.isPresent()) {
            TypeName returnType = TypeUtils.getOperationResultType(entityOpt.orElse(null), operation, cdsReturnType.get(), this.namesUtils, this.config);
            methodBuilder.returns(returnType);
        }
        if (entityOpt.isPresent()) {
            CdsEntity entity = entityOpt.get();
            CdsParameter bindingParameter = null;
            if (operation instanceof CdsBoundAction) {
                CdsBoundAction action = (CdsBoundAction)operation;
                bindingParameter = action.getBindingParameter();
            } else if (operation instanceof CdsBoundFunction) {
                CdsBoundFunction function = (CdsBoundFunction)operation;
                bindingParameter = function.getBindingParameter();
            }
            String bindingParameterName = bindingParameter != null ? bindingParameter.getName() : "ref";
            TypeName builderType = PoetTypeName.getTypeName(TypeUtils.builderClassName((CdsDefinition)entity).simpleName());
            ParameterSpec bindingParam = ParameterSpec.builder((TypeName)builderType, (String)bindingParameterName, (Modifier[])new Modifier[0]).build();
            methodBuilder.addParameter(bindingParam);
        }
        operation.parameters().forEach(param -> {
            Optional<String> paramName = NamesUtils.getNameIfNotIgnored((CdsAnnotatable)param, param.getName());
            if (paramName.isEmpty()) {
                return;
            }
            TypeName paramType = this.getParameterType(entityOpt.orElse(null), operation, (CdsParameter)param);
            String cdsNameValue = eventContextClassName.simpleName() + "." + CaseFormatHelper.toUpperUnderscore(param.getName());
            ParameterSpec paramSpec = ParameterSpec.builder((TypeName)paramType, (String)CaseFormatHelper.toLowerCamel(paramName.get()), (Modifier[])new Modifier[0]).addAnnotation(SpecWriterUtil.cdsNameAnnotation(cdsNameValue, "$L")).build();
            methodBuilder.addParameter(paramSpec);
        });
        return Optional.of(methodBuilder.build());
    }

    private TypeName getParameterType(CdsEntity boundTo, CdsOperation operation, CdsParameter param) {
        if (TypeUtils.isAnonymousType(param.getType(), this.config)) {
            ClassName innerType = TypeUtils.eventContextClassName((CdsDefinition)operation, boundTo, this.config).nestedClass(CaseFormatHelper.toUpperCamel(param.getName()));
            if (param.getType().isArrayed()) {
                return PoetTypeName.getArrayTypeName((TypeName)innerType);
            }
            return innerType;
        }
        return TypeUtils.getAttributeType(param.getType(), this.config);
    }

    private static boolean isServiceDraftEnabled(CdsService service) {
        return service.entities().anyMatch(entity -> entity.findAnnotation("@odata.draft.enabled").isPresent());
    }
}

