/************************************************************************
 * © 2019-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.generator;

import java.util.List;

import com.sap.cds.generator.util.GeneratorMode;
import com.sap.cds.generator.util.ParserMode;

public interface Configuration {

	ParserMode getParserMode();

	GeneratorMode getGeneratorMode();

	MethodStyle getMethodStyle();

	String getBasePackage();

	String getEventContext();

	List<String> getExcludes();

	List<String> getIncludes();

	String getClassNameSuffix();

	boolean getDocs();

	boolean fkAccessors();

	String getPluginInformation();

	void setPluginInformation(String pluginInformation);

	void setGenerationAnnotationDetailLevel(GeneratedAnnotationDetailLevel detailLevel);

	GeneratedAnnotationDetailLevel getGenerationAnnotationDetailLevel();

	default boolean getCqnServices() {
		return false;
	}

}
