/************************************************************************
 * © 2022-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.generator.util;

import java.time.Instant;

import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.GeneratedAnnotationDetailLevel;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec.Builder;

public class GeneratedAnnotationUtil {
	private static final String GENERATED_PACKAGE_NAME = "javax.annotation.processing";
	private static final String GENERATED_CLASS_NAME = "Generated";

	private final Configuration cfg;
	private final AnnotationSpec annotation;

	public GeneratedAnnotationUtil(Configuration cfg) {
		this.cfg = cfg;
		ClassName className = ClassName.get(GENERATED_PACKAGE_NAME, GENERATED_CLASS_NAME);
		AnnotationSpec.Builder builder = AnnotationSpec.builder(className);
		builder.addMember("value", "$S", "cds-maven-plugin");

		if (cfg.getGenerationAnnotationDetailLevel() == GeneratedAnnotationDetailLevel.FULL) {
			builder.addMember("date", "$S", Instant.now().toString())
				.addMember("comments", "$S", cfg.getPluginInformation());
		}

		annotation = builder.build();
	}

	public void addTo(Builder builder) {
		if (cfg.getGenerationAnnotationDetailLevel() != GeneratedAnnotationDetailLevel.NONE) {
			builder.addAnnotation(annotation);
		}
	}
}
