/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.util;

import com.sap.cds.Struct;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.PoetTypeName;
import com.sap.cds.generator.writer.CaseFormatHelper;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeUtils {
    private static final Logger logger = LoggerFactory.getLogger(TypeUtils.class);

    private TypeUtils() {
    }

    public static TypeName getAttributeType(CdsType type, Configuration cfg) {
        return TypeUtils.getAttributeType(type, cfg, null);
    }

    private static TypeName getAttributeType(CdsType type, Configuration cfg, String structTypeName) {
        TypeName attributeType;
        if (type.isAssociation()) {
            CdsAssociationType assocType = (CdsAssociationType)type.as(CdsAssociationType.class);
            CdsType target = assocType.getTargetAspect().orElseGet(() -> ((CdsAssociationType)assocType).getTarget());
            attributeType = PoetTypeName.getTypeFromCdsName(cfg.getBasePackage(), target.getQualifiedName(), target.getName());
            if (!CdsModelUtils.isSingleValued((CdsType)type)) {
                attributeType = TypeUtils.listOf(attributeType);
            }
        } else if (type.isSimple()) {
            attributeType = PoetTypeName.getTypeName(((CdsSimpleType)type.as(CdsSimpleType.class)).getJavaType().getTypeName());
        } else if (type.isStructured()) {
            String targetName = type.getQualifiedName();
            attributeType = targetName.isEmpty() && type.getName().isEmpty() && structTypeName != null ? PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(structTypeName)) : PoetTypeName.getTypeFromCdsName(cfg.getBasePackage(), targetName, type.getName());
        } else if (type.isArrayed()) {
            boolean arrayedInlinedStructuredType;
            CdsType itemsType = ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType();
            TypeName innerAttributeType = TypeUtils.getAttributeType(itemsType, cfg, !(arrayedInlinedStructuredType = type.getQualifiedName().contains(".")) ? type.getName() : null);
            if (innerAttributeType.toString().endsWith(".")) {
                String className = CaseFormatHelper.toUpperCamel(NamesUtils.unqualifiedName(type.getQualifiedName()));
                TypeName outer = PoetTypeName.getTypeName(NamesUtils.qualifiedJavaClass(cfg.getBasePackage(), NamesUtils.namespace(type.getQualifiedName())));
                attributeType = PoetTypeName.getArrayTypeName(PoetTypeName.getTypeName(outer + "." + className));
            } else {
                attributeType = PoetTypeName.getArrayTypeName(innerAttributeType);
            }
        } else {
            logger.warn("Interface Generation: Unsupported CDS Element with attribute name '" + type.getName() + "' and type '" + type + "'");
            return null;
        }
        return attributeType;
    }

    public static TypeName getReturnType(CdsElement attribute, Configuration cfg) {
        boolean isMedia = attribute.annotations().anyMatch(a -> "Core.MediaType".equals(a.getName()));
        if (isMedia && attribute.getType().isSimple()) {
            CdsSimpleType simpleType = (CdsSimpleType)attribute.getType().as(CdsSimpleType.class);
            return PoetTypeName.getTypeName(CdsBaseType.cdsJavaMediaType((CdsBaseType)simpleType.getType()).getName());
        }
        if (attribute.getType().isStructured() && attribute.getType().getQualifiedName().isEmpty()) {
            return PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(attribute.getName()));
        }
        if (TypeUtils.isAnonymousAspect(attribute)) {
            TypeName attributeType = PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(attribute.getName()));
            if (!CdsModelUtils.isSingleValued((CdsType)attribute.getType())) {
                attributeType = TypeUtils.listOf(attributeType);
            }
            return attributeType;
        }
        return TypeUtils.getAttributeType(attribute.getType(), cfg);
    }

    public static TypeName getOperationResultType(CdsDefinition operation, CdsType returnType, NamesUtils namesUtils) {
        if (TypeUtils.isAnonymousType(returnType)) {
            String RETURN_TYPE_SUFFIX = "ReturnType";
            return TypeUtils.getInnerEventContextClassName(operation, "ReturnType");
        }
        if (returnType.isStructured()) {
            return PoetTypeName.getTypeName(namesUtils.qualifiedJavaClassName((CdsDefinition)returnType));
        }
        if (returnType.isSimple()) {
            return PoetTypeName.getTypeName(((CdsSimpleType)returnType.as(CdsSimpleType.class)).getJavaType().getTypeName());
        }
        if (returnType.isArrayed()) {
            TypeName nestedType = TypeUtils.getOperationResultType(operation, ((CdsArrayedType)returnType.as(CdsArrayedType.class)).getItemsType(), namesUtils);
            return ParameterizedTypeName.get((ClassName)ClassName.get(Collection.class), (TypeName[])new TypeName[]{nestedType});
        }
        logger.warn("Consumption Interface Generation: Unsupported CDS Element with attribute name {} and type {}", (Object)operation.getName(), (Object)returnType.getName());
        return null;
    }

    public static ClassName getInnerEventContextClassName(CdsDefinition def, String innerClassName) {
        return ClassName.bestGuess((String)String.format("%s.%s", CaseFormatHelper.toUpperCamel(def.getName() + "Context"), CaseFormatHelper.toUpperCamel(innerClassName)));
    }

    public static ParameterizedTypeName listOf(TypeName type) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{type});
    }

    public static ClassName className(String name) {
        return ClassName.bestGuess((String)CaseFormatHelper.toUpperCamel(name));
    }

    public static ClassName builderClassName(CdsDefinition def) {
        return ClassName.bestGuess((String)(CaseFormatHelper.toUpperCamel(def.getName()) + "_"));
    }

    public static boolean isAnonymousAspect(CdsElement element) {
        Optional targetAspect;
        CdsType type = element.getType();
        return type.isAssociation() && (targetAspect = ((CdsAssociationType)type.as(CdsAssociationType.class)).getTargetAspect()).isPresent() && ((CdsType)targetAspect.get()).getQualifiedName().isEmpty();
    }

    public static boolean isAnonymousType(CdsType type) {
        if (type == null) {
            return false;
        }
        if (type.isArrayed()) {
            return TypeUtils.isAnonymousType(((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType());
        }
        return type.isStructured() && type.getQualifiedName().isEmpty();
    }

    public static boolean isCompositionOfAspectsWithStructuredElements(CdsElement element) {
        return ((CdsAssociationType)element.getType().as(CdsAssociationType.class)).getTargetAspect().map(ta -> ((CdsStructuredType)ta.as(CdsStructuredType.class)).elements().anyMatch(e -> e.getType().isStructured())).orElse(false);
    }

    public static Stream<CdsElement> getAnonymousElements(CdsElement element) {
        Optional targetAspect;
        CdsType type = element.getType();
        if (type.isAssociation() && (targetAspect = ((CdsAssociationType)type.as(CdsAssociationType.class)).getTargetAspect()).isPresent() && ((CdsType)targetAspect.get()).getQualifiedName().isEmpty()) {
            return ((CdsStructuredType)((CdsType)targetAspect.get()).as(CdsStructuredType.class)).elements();
        }
        return Stream.empty();
    }

    public static void addStaticMethod(TypeSpec.Builder builder, TypeName returnType, TypeSpec.Builder ... anonymousbuilder) {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"create").returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        codeBuilder.addStatement("return $T.create($T.class)", new Object[]{ClassName.get(Struct.class), returnType});
        methodBuilder.addCode(codeBuilder.build());
        if (anonymousbuilder.length > 0) {
            anonymousbuilder[0].addMethod(methodBuilder.build());
        } else {
            builder.addMethod(methodBuilder.build());
        }
    }

    public static void addStaticCreateForKeys(TypeSpec.Builder builder, CdsEntity entity, Map<String, ParameterSpec> parameters) {
        if (!parameters.isEmpty()) {
            ClassName returnType = TypeUtils.className(entity.getName());
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"create").returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
            parameters.forEach((name, spec) -> methodBuilder.addParameter(spec));
            CodeBlock.Builder codeBuilder = CodeBlock.builder();
            codeBuilder.addStatement("$T<String, Object> keys = new $T<>()", new Object[]{ClassName.get(Map.class), ClassName.get(HashMap.class)});
            parameters.forEach((name, spec) -> codeBuilder.addStatement("keys.put($L, $L)", new Object[]{name, spec.name}));
            codeBuilder.addStatement("return $T.access(keys).as($T.class)", new Object[]{ClassName.get(Struct.class), returnType});
            methodBuilder.addCode(codeBuilder.build());
            builder.addMethod(methodBuilder.build());
        }
    }

    public static List<CdsElement> getManagedToOneFks(CdsElement attribute) {
        return new OnConditionAnalyzer(attribute, false).getFkMapping().keySet().stream().map(m -> ((CdsStructuredType)attribute.getDeclaringType().as(CdsStructuredType.class)).findElement(m)).map(Optional::get).collect(Collectors.toList());
    }

    public static void logWarningForManyToManyWithStructElement(CdsModel model, CdsStructuredType struct) {
        Optional<CdsElement> assocElement;
        if (struct.elements().anyMatch(e -> e.getType().isStructured()) && (assocElement = model.entities().flatMap(CdsStructuredType::associations).filter(a -> ((CdsAssociationType)a.getType().as(CdsAssociationType.class)).getTargetAspect().map(ta -> ta.getName().equals(struct.getName())).orElse(false)).findFirst()).isPresent()) {
            logger.warn("Limited CRUD operation support available with composition of aspects(" + struct.getQualifiedName() + ") containing structured elements. Use dynamic queries in such cases.");
        }
    }
}

