/*******************************************************************
 * © 2019 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.generator.util;

import java.net.URI;

public interface FileLocation {

	/**
	 * The location of the file relative to the base generation directory.
	 * 
	 * @return a relative file location as {@link URI}.
	 */
	URI getUri();

	/**
	 * Specifies whether the file location represents a resource that needs to be written to the resources folder.
	 * 
	 * @return {@code true} to indicate that it must be written to the resources folder, otherwise it will be written to
	 *         the Java source directory.
	 */
	default boolean isResource() {
		return false;
	}
}
