/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.util;

import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.GeneratedAnnotationDetailLevel;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import java.time.Instant;

public class GeneratedAnnotationUtil {
    private static final String GENERATED_PACKAGE_NAME = "javax.annotation.processing";
    private static final String GENERATED_CLASS_NAME = "Generated";
    private final Configuration cfg;
    private final AnnotationSpec annotation;

    public GeneratedAnnotationUtil(Configuration cfg) {
        this.cfg = cfg;
        ClassName className = ClassName.get((String)GENERATED_PACKAGE_NAME, (String)GENERATED_CLASS_NAME, (String[])new String[0]);
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)className);
        builder.addMember("value", "$S", new Object[]{"cds-maven-plugin"});
        if (cfg.getGenerationAnnotationDetailLevel() == GeneratedAnnotationDetailLevel.FULL) {
            builder.addMember("date", "$S", new Object[]{Instant.now().toString()}).addMember("comments", "$S", new Object[]{cfg.getPluginInformation()});
        }
        this.annotation = builder.build();
    }

    public void addTo(TypeSpec.Builder builder) {
        if (this.cfg.getGenerationAnnotationDetailLevel() != GeneratedAnnotationDetailLevel.NONE) {
            builder.addAnnotation(this.annotation);
        }
    }
}

