/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.MethodStyle;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.PoetTypeName;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.writer.CaseFormatHelper;
import com.sap.cds.generator.writer.CreateConsumptionInterfaceVisitor;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.ql.CdsName;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.CdsAnnotatableImpl;
import com.sap.cds.util.CdsModelUtils;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public class CreateEventContextInterfaceVisitor
implements CdsVisitor {
    private static final String RETURN_TYPE = "ReturnType";
    private static final ParameterizedTypeName MAP_STR2OBJ = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), WildcardTypeName.subtypeOf(Object.class)});
    private static final String CDS_SERVICES_PACKAGE = "com.sap.cds.services";
    private static final String CQN_PACKAGE = "com.sap.cds.ql.cqn";
    private static final String CLASS_EVENT_CONTEXT = "EventContext";
    private static final String CLASS_EVENT_NAME = "EventName";
    private static final String CLASS_CQN_SELECT = "CqnSelect";
    static final String CONTEXT_SUFFIX = "Context";
    private static final String PROXYMETHOD_ARG_NAME = "entityName";
    private final TypeSpec.Builder builder;
    private final Configuration cfg;
    private final boolean bounded;
    private final NamesUtils namesUtils;
    private final String boundEntityName;
    private final String definitionName;

    public static CdsVisitor create(TypeSpec.Builder builder, Configuration config, String boundEntityName, String definitionName, NamesUtils namesUtils) {
        return new CreateEventContextInterfaceVisitor(builder, config, boundEntityName, definitionName, namesUtils);
    }

    private CreateEventContextInterfaceVisitor(TypeSpec.Builder builder, Configuration config, String boundEntityName, String definitionName, NamesUtils namesUtils) {
        this.builder = builder;
        this.cfg = config;
        this.boundEntityName = boundEntityName;
        this.definitionName = NamesUtils.qualifiedJavaClass(config.getBasePackage(), definitionName);
        this.builder.addSuperinterface((TypeName)ClassName.get((String)CDS_SERVICES_PACKAGE, (String)CLASS_EVENT_CONTEXT, (String[])new String[0]));
        this.bounded = boundEntityName != null;
        this.namesUtils = namesUtils;
    }

    public void visit(CdsAction action) {
        this.addGetCqnMethod();
        this.addSetCqnMethod();
        this.addStaticQualifiedAttribute((CdsDefinition)action);
        this.prepareDefinition((CdsDefinition)action);
    }

    public void visit(CdsFunction function) {
        this.addGetCqnMethod();
        this.addSetCqnMethod();
        this.addStaticQualifiedAttribute((CdsDefinition)function);
        this.prepareDefinition((CdsDefinition)function);
    }

    public void visit(CdsEvent event) {
        this.addGetter(event);
        this.addSetter(event);
        this.addStaticQualifiedAttribute((CdsDefinition)event);
        this.addStaticProxyMethod(event.getName());
        this.builder.addAnnotation(CreateEventContextInterfaceVisitor.eventNameAnnotation(event.getName(), "$S"));
    }

    private void addGetter(CdsEvent event) {
        String methodName = this.cfg.getMethodStyle() == MethodStyle.BEAN ? "getData" : "data";
        MethodSpec.Builder resultGetterBuilder = MethodSpec.methodBuilder((String)methodName).returns(PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(event.getName()))).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        this.builder.addMethod(resultGetterBuilder.build());
    }

    private void addSetter(CdsEvent event) {
        String methodName;
        TypeName returnType = TypeName.VOID;
        if (this.cfg.getMethodStyle() == MethodStyle.BEAN) {
            methodName = "setData";
        } else {
            methodName = "data";
            returnType = PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(event.getName() + CONTEXT_SUFFIX));
        }
        MethodSpec.Builder resultGetterBuilder = MethodSpec.methodBuilder((String)methodName).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(event.getName())), "event", new Modifier[0]);
        this.builder.addMethod(resultGetterBuilder.build());
    }

    private void addGetCqnMethod() {
        if (this.bounded) {
            String methodName = this.cfg.getMethodStyle() == MethodStyle.BEAN ? "getCqn" : "cqn";
            MethodSpec.Builder resultGetterBuilder = MethodSpec.methodBuilder((String)methodName).returns((TypeName)ClassName.get((String)CQN_PACKAGE, (String)CLASS_CQN_SELECT, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            this.builder.addMethod(resultGetterBuilder.build());
        }
    }

    private void addSetCqnMethod() {
        if (this.bounded) {
            TypeName returnType;
            String methodName = "cqn";
            if (this.cfg.getMethodStyle() == MethodStyle.BEAN) {
                returnType = TypeName.VOID;
                methodName = "setCqn";
            } else {
                returnType = PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(NamesUtils.unqualifiedName(this.definitionName) + CONTEXT_SUFFIX));
            }
            MethodSpec.Builder resultGetterBuilder = MethodSpec.methodBuilder((String)methodName).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)ClassName.get((String)CQN_PACKAGE, (String)CLASS_CQN_SELECT, (String[])new String[0]), "select", new Modifier[0]);
            this.builder.addMethod(resultGetterBuilder.build());
        }
    }

    private void addStaticQualifiedAttribute(CdsDefinition def) {
        String name = def.getName();
        FieldSpec staticField = FieldSpec.builder(String.class, (String)"CDS_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{name}).build();
        this.builder.addField(staticField);
    }

    private void prepareDefinition(CdsDefinition def) {
        String defName = (String)def.getAnnotationValue(CdsAnnotatableImpl.removeAt((String)"@cds.java.name"), (Object)def.getName());
        if (this.bounded) {
            this.addStaticProxyMethodBound(defName);
        }
        this.addResultMethod(def);
        this.addStaticProxyMethod(defName);
        this.builder.addAnnotation(CreateEventContextInterfaceVisitor.eventNameAnnotation(def.getName(), "$S"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addResultMethod(CdsDefinition def) {
        String getter;
        String setter;
        TypeName setReturnType;
        CdsType returnType;
        TypeName resultType = null;
        if (def instanceof CdsAction) {
            CdsAction action = (CdsAction)def;
            Optional actionType = action.returnType();
            if (!actionType.isPresent()) return;
            returnType = (CdsType)actionType.get();
        } else {
            CdsFunction function = (CdsFunction)def;
            returnType = function.getReturnType();
        }
        if (TypeUtils.isAnonymousType(returnType)) {
            resultType = this.generateInnerInterface(returnType, RETURN_TYPE);
        }
        if (resultType == null && (resultType = TypeUtils.getOperationResultType(def, returnType, this.namesUtils)) == null) {
            return;
        }
        if (this.cfg.getMethodStyle() == MethodStyle.BEAN) {
            setReturnType = TypeName.VOID;
            setter = "setResult";
            getter = "getResult";
        } else {
            setReturnType = PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(def.getName() + CONTEXT_SUFFIX));
            getter = "result";
            setter = "result";
        }
        MethodSpec.Builder resultSetterBuilder = MethodSpec.methodBuilder((String)setter).returns(setReturnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(resultType, CaseFormatHelper.toLowerCamel("result"), new Modifier[0]);
        MethodSpec.Builder resultGetterBuilder = MethodSpec.methodBuilder((String)getter).returns(resultType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        this.builder.addMethod(resultSetterBuilder.build());
        this.builder.addMethod(resultGetterBuilder.build());
    }

    private TypeName generateInnerInterface(CdsType returnType, String returnTypeName) {
        Stream elements;
        String unqualifiedClassName = returnTypeName;
        TypeName resultType = PoetTypeName.getTypeName(unqualifiedClassName);
        TypeSpec.Builder innerIntefaceBuilder = TypeSpec.interfaceBuilder((String)unqualifiedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        if (returnType.isStructured()) {
            elements = ((CdsStructuredType)returnType.as(CdsStructuredType.class)).elements();
        } else {
            resultType = PoetTypeName.getArrayTypeName(resultType);
            elements = ((CdsStructuredType)((CdsArrayedType)returnType.as(CdsArrayedType.class)).getItemsType().as(CdsStructuredType.class)).elements();
        }
        elements.forEach(e -> e.accept(CreateConsumptionInterfaceVisitor.create(innerIntefaceBuilder, this.cfg, unqualifiedClassName)));
        TypeUtils.addStaticMethod(this.builder, PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(unqualifiedClassName)), innerIntefaceBuilder);
        this.builder.addType(innerIntefaceBuilder.build());
        return resultType;
    }

    private void addStaticProxyMethod(String entityName) {
        TypeName returnType = PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(entityName + CONTEXT_SUFFIX));
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"create").returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        if (this.bounded) {
            methodBuilder.addParameter(TypeName.get(String.class), PROXYMETHOD_ARG_NAME, new Modifier[0]);
        }
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        codeBuilder.addStatement("return EventContext.create($T.class, $N)", new Object[]{returnType, this.bounded ? PROXYMETHOD_ARG_NAME : "null"});
        methodBuilder.addCode(codeBuilder.build());
        this.builder.addMethod(methodBuilder.build());
    }

    private void addStaticProxyMethodBound(String entityName) {
        TypeName returnType = PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(entityName + CONTEXT_SUFFIX));
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"create").returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        codeBuilder.addStatement("return EventContext.create($T.class, $S)", new Object[]{returnType, this.boundEntityName});
        methodBuilder.addCode(codeBuilder.build());
        this.builder.addMethod(methodBuilder.build());
    }

    private static AnnotationSpec eventNameAnnotation(String cdsName, String format) {
        return AnnotationSpec.builder((ClassName)ClassName.get((String)CDS_SERVICES_PACKAGE, (String)CLASS_EVENT_NAME, (String[])new String[0])).addMember("value", format, new Object[]{cdsName}).build();
    }

    public void visit(CdsParameter parameter) {
        this.addStaticAttribute(parameter);
        TypeName resultType = null;
        CdsType returnType = parameter.getType();
        if (TypeUtils.isAnonymousType(returnType)) {
            resultType = this.generateInnerInterface(returnType, NamesUtils.unqualifiedName(CaseFormatHelper.toUpperCamel(parameter.getName())));
            this.addGetterMethod(parameter, resultType);
            this.addSetterMethod(parameter, resultType);
        } else {
            this.addParamGetter(parameter);
            this.addParamSetter(parameter);
        }
    }

    private void addParamGetter(CdsParameter parameter) {
        TypeName returnType = TypeUtils.getAttributeType(parameter.getType(), this.cfg);
        this.addGetterMethod(parameter, returnType);
    }

    private void addGetterMethod(CdsParameter parameter, TypeName returnType) {
        if (returnType == null) {
            return;
        }
        Optional<String> parameterName = NamesUtils.getNameIfNotIgnored((CdsAnnotatable)parameter, parameter.getName());
        parameterName.ifPresent(name -> {
            Object getter = this.cfg.getMethodStyle().equals((Object)MethodStyle.BEAN) ? "get" + CaseFormatHelper.toUpperCamel(name) : CaseFormatHelper.toLowerCamel(name);
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)getter).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            this.addJavaDoc(parameter, methodBuilder);
            CreateEventContextInterfaceVisitor.addCdsNameAnnotation(methodBuilder, parameter.getName(), (String)getter);
            this.builder.addMethod(methodBuilder.build());
        });
    }

    private void addParamSetter(CdsParameter parameter) {
        TypeName paramType = this.getSetterParam(parameter.getType());
        this.addSetterMethod(parameter, paramType);
    }

    private void addSetterMethod(CdsParameter parameter, TypeName paramType) {
        if (paramType == null) {
            return;
        }
        Optional<String> parameterName = NamesUtils.getNameIfNotIgnored((CdsAnnotatable)parameter, parameter.getName());
        parameterName.ifPresent(name -> {
            Object setter;
            TypeName returnType;
            if (this.cfg.getMethodStyle() == MethodStyle.BEAN) {
                returnType = TypeName.VOID;
                setter = "set" + CaseFormatHelper.toUpperCamel(name);
            } else {
                returnType = PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(NamesUtils.unqualifiedName(this.definitionName) + CONTEXT_SUFFIX));
                setter = CaseFormatHelper.toLowerCamel(name);
            }
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)setter).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(paramType, CaseFormatHelper.toLowerCamel(name), new Modifier[0]);
            this.addJavaDoc(parameter, methodBuilder);
            CreateEventContextInterfaceVisitor.addCdsNameAnnotation(methodBuilder, parameter.getName(), (String)setter);
            this.builder.addMethod(methodBuilder.build());
        });
    }

    private TypeName getSetterParam(CdsType type) {
        if (type.isAssociation()) {
            if (CdsModelUtils.isSingleValued((CdsType)type)) {
                return MAP_STR2OBJ;
            }
            return CreateEventContextInterfaceVisitor.listOf((TypeName)WildcardTypeName.subtypeOf((TypeName)MAP_STR2OBJ));
        }
        return TypeUtils.getAttributeType(type, this.cfg);
    }

    private static AnnotationSpec cdsNameAnnotation(String cdsName, String format) {
        return AnnotationSpec.builder(CdsName.class).addMember("value", format, new Object[]{cdsName}).build();
    }

    private static MethodSpec.Builder addCdsNameAnnotation(MethodSpec.Builder builder, String cdsName, String javaName) {
        if (!cdsName.equals(CreateEventContextInterfaceVisitor.propertyName(javaName))) {
            builder.addAnnotation(CreateEventContextInterfaceVisitor.cdsNameAnnotation(CaseFormatHelper.toUpperUnderscore(cdsName), "$L"));
        }
        return builder;
    }

    private static String propertyName(String javaName) {
        if (javaName.startsWith("set") || javaName.startsWith("get")) {
            javaName = CaseFormatHelper.lowercaseFirst(javaName.substring(3));
        }
        return javaName;
    }

    private static ParameterizedTypeName listOf(TypeName type) {
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{type});
    }

    private void addStaticAttribute(CdsParameter parameter) {
        String name = CaseFormatHelper.toUpperUnderscore(parameter.getName());
        FieldSpec staticField = FieldSpec.builder(String.class, (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{parameter.getName()}).build();
        this.builder.addField(staticField);
    }

    private void addJavaDoc(CdsParameter param, MethodSpec.Builder methodBuilder) {
        if (this.cfg.getDocs()) {
            SpecWriterUtil.setJavaDoc((CdsAnnotatable)param, methodBuilder);
        }
    }
}

