/*********************************************************************
 * (C) 2023 SAP SE or an SAP affiliate company. All rights reserved. *
 *********************************************************************/
package com.sap.cds.generator;

/**
 *  Defines the level of details for the annotation @{@link javax.annotation.processing.Generated} that
 *  is added to the interfaces generated from the CDS models.
 */
public enum GeneratedAnnotationDetailLevel {
	/**
	 * Annotation is not added at all.
	 */
	NONE,

	/**
	 * Annotation added with just the name of the generator.
	 */
	MINIMAL,

	/**
	 * Annotation added with the name of the generator, versions of CDS artefacts used and a date and time when objects were generated.
	 * This is the default behavior.
	 */
	FULL
}
