/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator;

import com.google.common.base.Strings;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.GeneratedAnnotationDetailLevel;
import com.sap.cds.generator.MethodStyle;
import com.sap.cds.generator.util.GeneratorMode;
import com.sap.cds.generator.util.ParserMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class ConfigurationImpl
implements Configuration {
    private ParserMode parserMode = ParserMode.TOLERANT;
    private GeneratorMode generatorMode = GeneratorMode.TOLERANT;
    private MethodStyle methodStyle = MethodStyle.BEAN;
    private String classNameSuffix = "_";
    private String basePackage = "";
    private boolean eventContext = false;
    private List<String> excludes = new ArrayList<String>();
    private List<String> includes = new ArrayList<String>();
    private boolean docs = true;
    private boolean fkAccessors = false;
    private GeneratedAnnotationDetailLevel generatedAnnotationDetailLevel = GeneratedAnnotationDetailLevel.FULL;
    private String pluginInformation = "";
    private boolean cqnServices = false;
    private boolean sharedInterfaces = false;

    @Override
    public GeneratorMode getGeneratorMode() {
        return this.generatorMode;
    }

    public void setGeneratorMode(GeneratorMode generatorMode) {
        this.generatorMode = generatorMode;
    }

    public void setClassNameSuffix(String suffix) {
        this.classNameSuffix = suffix;
    }

    @Override
    public String getClassNameSuffix() {
        return this.classNameSuffix;
    }

    public void setGeneratorMode(String generatorMode) {
        if (!Strings.isNullOrEmpty((String)generatorMode)) {
            this.generatorMode = GeneratorMode.valueOf(generatorMode.toUpperCase(Locale.US));
        }
    }

    @Override
    public ParserMode getParserMode() {
        return this.parserMode;
    }

    public void setParserMode(ParserMode parserMode) {
        this.parserMode = parserMode;
    }

    public void setParserMode(String parserMode) {
        if (!Strings.isNullOrEmpty((String)parserMode)) {
            this.parserMode = ParserMode.valueOf(parserMode.toUpperCase(Locale.US));
        }
    }

    @Override
    public MethodStyle getMethodStyle() {
        return this.methodStyle;
    }

    public void setMethodStyle(MethodStyle methodMode) {
        this.methodStyle = methodMode;
    }

    public void setMethodStyle(String interfaceMode) {
        if (!Strings.isNullOrEmpty((String)interfaceMode)) {
            this.methodStyle = MethodStyle.valueOf(interfaceMode.toUpperCase(Locale.US));
        }
    }

    @Override
    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        if (!Strings.isNullOrEmpty((String)basePackage)) {
            this.basePackage = basePackage;
        }
    }

    @Override
    public List<String> getExcludes() {
        return Collections.unmodifiableList(this.excludes);
    }

    public void setExcludes(List<String> excludes) {
        if (excludes != null) {
            this.excludes.addAll(excludes);
        }
    }

    @Override
    public boolean getEventContext() {
        return this.eventContext;
    }

    @Deprecated(since="2.7.0", forRemoval=true)
    public void setEventContext(String bool) {
        if (!Strings.isNullOrEmpty((String)bool)) {
            this.eventContext = Boolean.parseBoolean(bool);
        }
    }

    public void setEventContext(boolean eventContext) {
        this.eventContext = eventContext;
    }

    @Override
    public boolean getDocs() {
        return this.docs;
    }

    public void setDocs(boolean readDocs) {
        this.docs = readDocs;
    }

    @Override
    public List<String> getIncludes() {
        return Collections.unmodifiableList(this.includes);
    }

    public void setIncludes(List<String> includes) {
        if (includes != null) {
            this.includes.addAll(includes);
        }
    }

    @Override
    public boolean fkAccessors() {
        return this.fkAccessors;
    }

    public void setFkAccessors(boolean fkAccessors) {
        this.fkAccessors = fkAccessors;
    }

    @Override
    public String getPluginInformation() {
        return this.pluginInformation;
    }

    public void setPluginInformation(String pluginInformation) {
        this.pluginInformation = pluginInformation;
    }

    public void setGenerationAnnotationDetailLevel(GeneratedAnnotationDetailLevel detailLevel) {
        this.generatedAnnotationDetailLevel = detailLevel;
    }

    @Override
    public GeneratedAnnotationDetailLevel getGenerationAnnotationDetailLevel() {
        return this.generatedAnnotationDetailLevel;
    }

    public void setCqnServices(boolean cqnServices) {
        this.cqnServices = cqnServices;
    }

    @Override
    public boolean getCqnServices() {
        return this.cqnServices;
    }

    @Override
    public boolean getSharedInterfaces() {
        return this.sharedInterfaces;
    }

    public void setSharedInterfaces(boolean value) {
        this.sharedInterfaces = value;
    }
}

