/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.PoetTypeName;
import com.sap.cds.generator.writer.CaseFormatHelper;
import com.sap.cds.generator.writer.Types;
import com.sap.cds.ql.CdsName;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class WrapperInterfaceCreator {
    private static final String DOT = ".";
    private final TypeSpec.Builder builder;
    private final CdsModel model;
    private final Configuration cfg;
    private final NamesUtils namesUtils;

    public static WrapperInterfaceCreator create(TypeSpec.Builder builder, CdsModel model, Configuration cfg) {
        return new WrapperInterfaceCreator(builder, model, cfg);
    }

    private WrapperInterfaceCreator(TypeSpec.Builder builder, CdsModel model, Configuration cfg) {
        this.builder = builder;
        this.model = model;
        this.cfg = cfg;
        this.namesUtils = new NamesUtils(cfg);
    }

    public boolean generateInterface(String context) {
        List<CdsDefinition> definitionList = this.getEntities(context);
        definitionList.addAll(this.getEvents(context));
        definitionList.addAll(this.getActionsAndFunctions(context));
        if (definitionList.isEmpty()) {
            return false;
        }
        if (context != null) {
            this.builder.addAnnotation(AnnotationSpec.builder(CdsName.class).addMember("value", "$S", new Object[]{context}).build());
            this.addStaticQualifiedAttribute(context);
        }
        definitionList.stream().forEach(d -> {
            if (d instanceof CdsEntity) {
                String interfaceName = CaseFormatHelper.toUpperCamel(d.getName()) + this.cfg.getClassNameSuffix();
                ParameterizedTypeName type = ParameterizedTypeName.get((ClassName)Types.CLASS, (TypeName[])new TypeName[]{PoetTypeName.getTypeName(interfaceName)});
                FieldSpec staticField = FieldSpec.builder((TypeName)type, (String)CaseFormatHelper.toUpperUnderscore(CaseFormatHelper.toUpperCamel(d.getName())), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("$N.class", new Object[]{interfaceName}).build();
                this.builder.addField(staticField);
            }
        });
        return true;
    }

    private List<CdsDefinition> getEvents(String context) {
        if (context == null) {
            return this.model.events().filter(e -> !e.getQualifiedName().contains(DOT)).collect(Collectors.toList());
        }
        return this.model.events().filter(e -> this.filterDefinitions(context, (CdsDefinition)e) && !this.namesUtils.isExcluded(e.getQualifiedName())).collect(Collectors.toList());
    }

    private List<CdsDefinition> getActionsAndFunctions(String context) {
        ArrayList<CdsDefinition> definitionList = new ArrayList<CdsDefinition>();
        if (context == null) {
            this.model.actions().filter(a -> !a.getQualifiedName().contains(DOT)).forEach(definitionList::add);
            this.model.functions().filter(f -> !f.getQualifiedName().contains(DOT)).forEach(definitionList::add);
        }
        this.model.actions().filter(a -> this.filterDefinitions(context, (CdsDefinition)a) && !this.namesUtils.isExcluded(a.getQualifiedName())).forEach(definitionList::add);
        this.model.functions().filter(f -> this.filterDefinitions(context, (CdsDefinition)f) && !this.namesUtils.isExcluded(f.getQualifiedName())).forEach(definitionList::add);
        return definitionList;
    }

    private void addStaticQualifiedAttribute(String context) {
        FieldSpec staticEntityField = FieldSpec.builder(String.class, (String)"CDS_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{context}).build();
        this.builder.addField(staticEntityField);
    }

    private List<CdsDefinition> getEntities(String context) {
        if (context == null) {
            return this.model.concreteEntities().filter(e -> !e.getQualifiedName().contains(DOT) && NamesUtils.isValidTechnicalEntity(this.model, e.getQualifiedName())).collect(Collectors.toList());
        }
        return this.model.concreteEntities().filter(e -> this.filterDefinitions(context, (CdsDefinition)e) && !this.namesUtils.isExcluded(e.getQualifiedName()) && NamesUtils.isValidTechnicalEntity(this.model, e.getQualifiedName())).collect(Collectors.toList());
    }

    private boolean filterDefinitions(String context, CdsDefinition def) {
        String name = def.getName();
        String qualifiedName = def.getQualifiedName();
        return Objects.equals(context, NamesUtils.qualifiedContextname(qualifiedName, name));
    }
}

