/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.PoetTypeName;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsEnumType;
import com.sap.cds.reflect.CdsVisitor;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Set;
import javax.lang.model.element.Modifier;

class CreateEnumConstantClassVisitor
implements CdsVisitor {
    private final TypeSpec.Builder result;
    private static final Set<Class<?>> WITH_PARSE = Set.of(LocalDate.class, Instant.class, LocalTime.class);
    private static final Set<Class<?>> WITH_VALUE_OF = Set.of(Long.class, Float.class, Double.class);
    private static final Set<Class<?>> SUPPORTED = Set.of(String.class, Boolean.class, Integer.class, Short.class, BigDecimal.class);

    CreateEnumConstantClassVisitor(TypeSpec.Builder result) {
        this.result = result;
    }

    public void visit(CdsEnumType<?> type) {
        if (this.isSupportedType(type.getType())) {
            this.result.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            this.result.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
            TypeName itemType = PoetTypeName.getTypeName(type.getJavaType().getCanonicalName());
            type.enumerals().forEach((name, enumeral) -> NamesUtils.getNameIfNotIgnored((CdsAnnotatable)enumeral, name).map(NamesUtils::javaSafeConstantName).ifPresent(constantName -> {
                FieldSpec.Builder field = FieldSpec.builder((TypeName)itemType, (String)constantName, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
                this.addInitialValue(field, type.getType(), enumeral.value());
                this.result.addField(field.build());
            }));
        }
    }

    private boolean isSupportedType(CdsBaseType type) {
        return SUPPORTED.contains(type.javaType()) || WITH_VALUE_OF.contains(type.javaType()) || WITH_PARSE.contains(type.javaType());
    }

    private void addInitialValue(FieldSpec.Builder field, CdsBaseType type, Object value) {
        if (type.javaType().equals(String.class)) {
            field.initializer("$S", new Object[]{value});
        } else if (type.javaType().equals(Boolean.class) || type.javaType().equals(Integer.class) || type.javaType().equals(Short.class)) {
            field.initializer("$L", new Object[]{value});
        } else if (type.javaType().equals(BigDecimal.class)) {
            field.initializer("new $T($S)", new Object[]{type.javaType(), value.toString()});
        } else if (WITH_VALUE_OF.contains(type.javaType())) {
            field.initializer("$T.valueOf($S)", new Object[]{type.javaType(), value.toString()});
        } else if (WITH_PARSE.contains(type.javaType())) {
            field.initializer("$T.parse($S)", new Object[]{type.javaType(), value.toString()});
        } else {
            throw new UnsupportedOperationException("Enum type: " + type.javaType() + " is implemented yet.");
        }
    }
}

