/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.MethodStyle;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.PoetTypeName;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.writer.CaseFormatHelper;
import com.sap.cds.generator.writer.ModelWriter;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.generator.writer.Types;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.CdsEventBuilder;
import com.sap.cds.util.CdsModelUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public class CreateConsumptionInterfaceVisitor
implements CdsVisitor {
    private static final ParameterizedTypeName MAP_STR2OBJ = ParameterizedTypeName.get((ClassName)Types.MAP, (TypeName[])new TypeName[]{Types.STRING, WildcardTypeName.subtypeOf(Object.class)});
    private final TypeSpec.Builder builder;
    private final Configuration cfg;
    private final String typeName;
    private final ModelWriter.Context context;

    CreateConsumptionInterfaceVisitor(TypeSpec.Builder builder, String typeName, ModelWriter.Context context) {
        this.builder = builder;
        this.cfg = context.config();
        this.typeName = typeName;
        this.context = context;
        if (!builder.superinterfaces.contains(Types.CDS_DATA)) {
            this.builder.addSuperinterface((TypeName)Types.CDS_DATA);
        }
    }

    public void visit(CdsEntity entity) {
        this.addRefMethod(entity);
        TypeUtils.addStaticMethod(this.builder, (TypeName)TypeUtils.className(entity.getName()), new TypeSpec.Builder[0]);
        LinkedHashMap<String, ParameterSpec> keyElements = new LinkedHashMap<String, ParameterSpec>();
        entity.keyElements().forEach(key -> NamesUtils.getNameIfNotIgnored((CdsAnnotatable)key, key.getName()).ifPresent(name -> keyElements.put(CaseFormatHelper.toUpperUnderscore(name), ParameterSpec.builder((TypeName)this.getSetterParam((CdsElement)key), (String)CaseFormatHelper.toLowerCamel(name), (Modifier[])new Modifier[0]).build())));
        if (keyElements.size() == 1) {
            TypeUtils.addStaticCreateForKeys(this.builder, entity, keyElements);
        }
        this.builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(entity.getQualifiedName(), "$S"));
    }

    public void visit(CdsEvent event) {
        TypeUtils.addStaticMethod(this.builder, PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(event.getName())), new TypeSpec.Builder[0]);
        this.builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(event.getQualifiedName(), "$S"));
    }

    public void visit(CdsStructuredType struct) {
        TypeUtils.addStaticMethod(this.builder, PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(struct.getName())), new TypeSpec.Builder[0]);
        this.builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(struct.getQualifiedName(), "$S"));
    }

    public void visit(CdsArrayedType type) {
        if (!type.getQualifiedName().isEmpty() && type.getItemsType().isStructured() && type.getItemsType().getQualifiedName().isEmpty() && !type.getItemsType().isSimple()) {
            this.builder.superinterfaces.clear();
            TypeSpec.Builder innerIntefaceBuilder = TypeSpec.interfaceBuilder((String)"Item").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
            ((CdsStructuredType)type.getItemsType().as(CdsStructuredType.class)).elements().forEach(e -> e.accept((CdsVisitor)new CreateConsumptionInterfaceVisitor(innerIntefaceBuilder, "Item", this.context)));
            TypeUtils.addStaticMethod(this.builder, PoetTypeName.getTypeName("Item"), innerIntefaceBuilder);
            this.builder.addType(innerIntefaceBuilder.build());
        }
    }

    public void visit(CdsElement element) {
        if (this.context.isTenantDiscriminator(element)) {
            return;
        }
        SpecWriterUtil.addStaticField(this.builder, element);
        if (this.isAnonymousType(element)) {
            String unqualifiedClassName = NamesUtils.unqualifiedName(CaseFormatHelper.toUpperCamel(element.getName()));
            TypeSpec.Builder innerIntefaceBuilder = TypeSpec.interfaceBuilder((String)unqualifiedClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
            CdsType type = element.getType();
            Stream elements = type.isStructured() && type.getQualifiedName().isEmpty() ? ((CdsStructuredType)type.as(CdsStructuredType.class)).elements() : (type.isArrayed() ? ((CdsStructuredType)((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType().as(CdsStructuredType.class)).elements() : TypeUtils.getAnonymousElements(element));
            String qualifiedElementName = NamesUtils.innerInterfaceQualifiedName(element, this.cfg.getBasePackage());
            elements.forEach(e -> e.accept((CdsVisitor)new CreateConsumptionInterfaceVisitor(innerIntefaceBuilder, qualifiedElementName, this.context)));
            TypeUtils.addStaticMethod(this.builder, PoetTypeName.getTypeName(CaseFormatHelper.toUpperCamel(unqualifiedClassName)), innerIntefaceBuilder);
            this.populateGetter(element, TypeUtils.getReturnType(element, this.cfg), false);
            this.populateSetter(element, TypeUtils.getReturnType(element, this.cfg), false);
            this.builder.addType(innerIntefaceBuilder.build());
        } else if (element.getType().isEnum()) {
            this.getter(element);
            this.setter(element);
        } else {
            this.getter(element);
            this.setter(element);
        }
        if (this.cfg.fkAccessors() && CdsModelUtils.managedToOne((CdsType)element.getType()) && !element.getName().equals("DraftAdministrativeData")) {
            SpecWriterUtil.addFkStaticField(this.builder, element);
            this.addFkMethods(element);
        }
    }

    private void addRefMethod(CdsEntity entity) {
        if (!entity.isAbstract()) {
            ClassName returnType = TypeUtils.builderClassName((CdsDefinition)entity);
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"ref").returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            this.builder.addMethod(methodBuilder.build());
        }
    }

    private boolean isAnonymousType(CdsElement element) {
        CdsType type = element.getType();
        if (type.isArrayed()) {
            if (type.getQualifiedName().startsWith(element.getDeclaringType().getQualifiedName())) {
                CdsType itemsType = ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType();
                return itemsType.isStructured() && itemsType.getQualifiedName().isEmpty();
            }
            return false;
        }
        if (type.isStructured() && type.getQualifiedName().isEmpty()) {
            return true;
        }
        return TypeUtils.isAnonymousAspect(element);
    }

    private void setter(CdsElement attribute) {
        TypeName paramType = this.getSetterParam(attribute);
        if (paramType == null) {
            return;
        }
        this.populateSetter(attribute, paramType, false);
    }

    private void populateSetter(CdsElement attribute, TypeName paramType, boolean cdsPath) {
        Optional<String> attributeName = NamesUtils.getNameIfNotIgnored((CdsAnnotatable)attribute, attribute.getName());
        attributeName.ifPresent(name -> {
            Object setter;
            TypeName returnType;
            if (this.cfg.getMethodStyle() == MethodStyle.BEAN) {
                returnType = TypeName.VOID;
                setter = "set" + CaseFormatHelper.toUpperCamel(name);
            } else {
                returnType = PoetTypeName.getTypeName(this.typeName);
                setter = CaseFormatHelper.toLowerCamel(name);
            }
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)setter).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(paramType, CaseFormatHelper.toLowerCamel(name), new Modifier[0]);
            this.addJavaDoc(attribute, methodBuilder);
            if (cdsPath) {
                SpecWriterUtil.addCdsPathAnnotation(methodBuilder, attribute.getName(), (String)setter);
            } else {
                SpecWriterUtil.addCdsNameAnnotation(methodBuilder, attribute, (String)setter);
            }
            this.builder.addMethod(methodBuilder.build());
        });
    }

    private TypeName getSetterParam(CdsElement element) {
        if (element.getType().isAssociation()) {
            if (CdsModelUtils.isSingleValued((CdsType)element.getType())) {
                return MAP_STR2OBJ;
            }
            return TypeUtils.listOf((TypeName)WildcardTypeName.subtypeOf((TypeName)MAP_STR2OBJ));
        }
        return TypeUtils.getReturnType(element, this.cfg);
    }

    private void getter(CdsElement attribute) {
        TypeName returnType = TypeUtils.getReturnType(attribute, this.cfg);
        if (returnType == null) {
            return;
        }
        this.populateGetter(attribute, returnType, false);
    }

    private void populateGetter(CdsElement attribute, TypeName returnType, boolean cdsPath) {
        Optional<String> attributeName = NamesUtils.getNameIfNotIgnored((CdsAnnotatable)attribute, attribute.getName());
        attributeName.ifPresent(name -> {
            Object getter = this.cfg.getMethodStyle().equals((Object)MethodStyle.BEAN) ? "get" + CaseFormatHelper.toUpperCamel(name) : CaseFormatHelper.toLowerCamel(name);
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)getter).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            this.addJavaDoc(attribute, methodBuilder);
            if (cdsPath) {
                SpecWriterUtil.addCdsPathAnnotation(methodBuilder, attribute.getName(), (String)getter);
            } else {
                SpecWriterUtil.addCdsNameAnnotation(methodBuilder, attribute, (String)getter);
            }
            this.builder.addMethod(methodBuilder.build());
        });
    }

    private void addJavaDoc(CdsElement attribute, MethodSpec.Builder methodBuilder) {
        if (!(attribute.getDeclaringType() instanceof CdsEventBuilder.EventProxy) && this.cfg.getDocs()) {
            SpecWriterUtil.setJavaDoc((CdsAnnotatable)attribute, methodBuilder);
        }
    }

    private void addFkMethods(CdsElement attribute) {
        TypeUtils.getManagedToOneFks(attribute).forEach(fkElement -> {
            if (this.context.isTenantDiscriminator((CdsElement)fkElement)) {
                return;
            }
            TypeName keyReturnType = TypeUtils.getReturnType(fkElement, this.cfg);
            if (keyReturnType == null) {
                return;
            }
            this.populateSetter((CdsElement)fkElement, keyReturnType, true);
            this.populateGetter((CdsElement)fkElement, keyReturnType, true);
        });
    }
}

