/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.google.common.collect.Streams;
import com.sap.cds.generator.Cds4jCodegen;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.EntityWriterException;
import com.sap.cds.generator.util.GeneratedAnnotationUtil;
import com.sap.cds.generator.util.GeneratedFile;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.util.UnSupportedModelException;
import com.sap.cds.generator.writer.CreateAppServiceInterfaceVisitor;
import com.sap.cds.generator.writer.CreateBuilderInterfaceVisitor;
import com.sap.cds.generator.writer.CreateConsumptionInterfaceVisitor;
import com.sap.cds.generator.writer.CreateEnumConstantClassVisitor;
import com.sap.cds.generator.writer.CreateEventContextInterfaceVisitor;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.generator.writer.WrapperInterfaceCreator;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEnumType;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.CdsEventBuilder;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileObject;

public class ModelWriter
implements CdsVisitor {
    private final GeneratedFile.Consumer consumer;
    private final Configuration config;
    private final CdsModel model;
    private final Map<String, CdsDefinition> wrapperMap;
    private final Set<String> builderInterfaces;
    private final NamesUtils namesUtils;
    private final GeneratedAnnotationUtil generated;
    private final List<String> generatedServices = new ArrayList<String>();
    private final Context context;

    public ModelWriter(GeneratedFile.Consumer consumer, Configuration config, CdsModel model) {
        this.consumer = consumer;
        this.config = config;
        this.model = model;
        this.wrapperMap = new HashMap<String, CdsDefinition>();
        this.builderInterfaces = new HashSet<String>();
        this.namesUtils = new NamesUtils(config);
        this.generated = new GeneratedAnnotationUtil(config);
        this.context = new Context((String)model.getMeta("tenantDiscriminator"), this.config, this.namesUtils);
    }

    public void visit(CdsModel model) {
        this.wrapperMap.values().forEach(this::generateWrapperInterface);
    }

    public void visit(CdsEntity entity) {
        NamesUtils.checkForJavaKeyword(entity.getQualifiedName());
        if (!this.namesUtils.isExcluded(entity.getQualifiedName()) && NamesUtils.isValidTechnicalEntity(this.config, this.model, entity)) {
            this.collectWrapperInterfaces((CdsDefinition)entity);
            this.generateBuilderInterface((CdsDefinition)entity);
            this.generateConsumptionInterface((CdsDefinition)entity);
            if (this.config.getEventContext()) {
                Streams.concat((Stream[])new Stream[]{entity.actions(), entity.functions()}).forEach(a -> this.generateEventContextInterface((CdsDefinition)a, entity));
            }
        }
    }

    public void visit(CdsEvent event) {
        NamesUtils.checkForJavaKeyword(event.getQualifiedName());
        if (!this.namesUtils.isExcluded(event.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)event);
            this.generateBuilderInterface((CdsDefinition)event);
            this.generateConsumptionInterface((CdsDefinition)event);
            if (this.config.getEventContext()) {
                this.generateEventContextInterface((CdsDefinition)event, null);
            }
        }
    }

    public void visit(CdsAction action) {
        if (this.config.getEventContext() && !this.namesUtils.isExcluded(action.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)action);
            this.generateEventContextInterface((CdsDefinition)action, null);
        }
    }

    public void visit(CdsFunction function) {
        if (this.config.getEventContext() && !this.namesUtils.isExcluded(function.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)function);
            this.generateEventContextInterface((CdsDefinition)function, null);
        }
    }

    public void visit(CdsArrayedType type) {
        if (!type.getQualifiedName().isEmpty() && type.getItemsType().isStructured() && type.getItemsType().getQualifiedName().isEmpty() && !type.getItemsType().isSimple()) {
            NamesUtils.checkForJavaKeyword(type.getQualifiedName());
            if (!this.namesUtils.isExcluded(type.getQualifiedName())) {
                this.generateConsumptionInterface((CdsDefinition)type);
            }
        }
    }

    public void visit(CdsStructuredType struct) {
        if (!struct.getName().isEmpty()) {
            NamesUtils.checkForJavaKeyword(struct.getQualifiedName());
            if (!this.namesUtils.isExcluded(struct.getQualifiedName())) {
                this.generateConsumptionInterface((CdsDefinition)struct);
                if (this.isTargetAspect(struct)) {
                    TypeUtils.logWarningForManyToManyWithStructElement(this.model, struct);
                    this.generateBuilderInterface((CdsDefinition)struct);
                }
            }
        }
    }

    public void visit(CdsService service) {
        this.generateTypedAppServiceInterface(service);
    }

    public void visit(CdsEnumType<?> type) {
        if (!this.namesUtils.isExcluded(type.getQualifiedName())) {
            NamesUtils.getNameIfNotIgnored(type, type.getName()).ifPresent(name -> {
                TypeSpec.Builder result = TypeSpec.classBuilder((ClassName)TypeUtils.className(name)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
                result.addAnnotation(SpecWriterUtil.cdsNameAnnotation(type.getQualifiedName(), "$S"));
                type.accept((CdsVisitor)new CreateEnumConstantClassVisitor(result));
                if (!result.fieldSpecs.isEmpty()) {
                    this.generated.addTo(result);
                    this.writeType(NamesUtils.packageName((CdsDefinition)type, this.config.getBasePackage()), result.build());
                }
            });
        }
    }

    public List<String> getGeneratedServices() {
        return this.generatedServices;
    }

    private void collectWrapperInterfaces(CdsDefinition def) {
        String packageName = NamesUtils.packageName(def, this.config.getBasePackage());
        this.wrapperMap.put(packageName, def);
    }

    private void generateWrapperInterface(CdsDefinition def) {
        String qualifiedName = def.getQualifiedName();
        String name = def.getName();
        String packageName = NamesUtils.packageName(def, this.config.getBasePackage());
        String qualifiedWrapperName = NamesUtils.qualifiedWrapperBuilderName(def, this.config.getClassNameSuffix(), true);
        while (this.builderInterfaces.contains(qualifiedWrapperName.toLowerCase(Locale.US))) {
            qualifiedWrapperName = NamesUtils.getResolvedWrapperName(qualifiedWrapperName, this.config.getClassNameSuffix());
        }
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((String)NamesUtils.unqualifiedName(qualifiedWrapperName)).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.generated.addTo(builder);
        if (new WrapperInterfaceCreator(builder, this.model, this.config).generateInterface(NamesUtils.qualifiedContextname(qualifiedName, name))) {
            this.writeType(packageName, builder.build());
        }
    }

    private void generateConsumptionInterface(CdsDefinition def) {
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(TypeUtils.className(def.getName()));
        this.addJavadoc(builder, def, () -> !(def instanceof CdsEventBuilder.EventProxy) && this.config.getDocs());
        String qualifiedTypeName = this.namesUtils.qualifiedJavaClassName(def);
        def.accept((CdsVisitor)new CreateConsumptionInterfaceVisitor(builder, qualifiedTypeName, this.context));
        ((List)def.getAnnotationValue("@cds.java.extends".substring(1), Collections.emptyList())).stream().map(arg_0 -> ((CdsModel)this.model).getStructuredType(arg_0)).map(this::throwErrorOnExtendEntity).map(this.namesUtils::qualifiedJavaClassName).map(ClassName::bestGuess).forEach(arg_0 -> ((TypeSpec.Builder)builder).addSuperinterface(arg_0));
        this.generated.addTo(builder);
        TypeSpec typeSpec = builder.build();
        String packageName = NamesUtils.packageName(def, this.config.getBasePackage());
        this.writeType(packageName, typeSpec);
    }

    private void generateEventContextInterface(CdsDefinition def, CdsEntity boundEntity) {
        if (Cds4jCodegen.isIgnored(def)) {
            return;
        }
        ClassName interfaceName = TypeUtils.eventContextClassName(def, boundEntity, this.config);
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(interfaceName);
        this.addJavadoc(builder, def, this.config::getDocs);
        String boundEntityName = boundEntity == null ? null : boundEntity.getQualifiedName();
        def.accept((CdsVisitor)new CreateEventContextInterfaceVisitor(builder, interfaceName, boundEntityName, this.context));
        this.generated.addTo(builder);
        TypeSpec typeSpec = builder.build();
        this.writeType(interfaceName.packageName(), typeSpec);
    }

    private CdsStructuredType throwErrorOnExtendEntity(CdsStructuredType struct) {
        if (struct.getKind().equals((Object)CdsKind.ENTITY) && !((CdsEntity)struct.as(CdsEntity.class)).isAbstract()) {
            throw new UnSupportedModelException("The '@cds.java.extends' annotation does not support extending an entity.");
        }
        return struct;
    }

    private void generateBuilderInterface(CdsDefinition def) {
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(TypeUtils.builderClassName(def));
        this.addJavadoc(builder, def, this.config::getDocs);
        def.accept((CdsVisitor)new CreateBuilderInterfaceVisitor(builder, this.context));
        this.builderInterfaces.add(NamesUtils.qualifiedWrapperBuilderName(def, this.config.getClassNameSuffix(), false).toLowerCase(Locale.US));
        this.generated.addTo(builder);
        TypeSpec typeSpec = builder.build();
        String packageName = NamesUtils.packageName(def, this.config.getBasePackage());
        this.writeType(packageName, typeSpec);
    }

    private void generateTypedAppServiceInterface(CdsService def) {
        if (!this.config.getEventContext() || !this.config.getCqnServices() || this.namesUtils.isExcluded(def.getQualifiedName()) || Cds4jCodegen.isIgnored((CdsDefinition)def)) {
            return;
        }
        ClassName interfaceName = TypeUtils.typedServiceClassName(def, this.config);
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((ClassName)interfaceName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.addJavadoc(builder, (CdsDefinition)def, this.config::getDocs);
        this.generated.addTo(builder);
        def.accept((CdsVisitor)new CreateAppServiceInterfaceVisitor(builder, interfaceName, this.context));
        TypeSpec typeSpec = builder.build();
        this.writeType(interfaceName.packageName(), typeSpec);
        this.generatedServices.add(interfaceName.canonicalName());
    }

    private void addJavadoc(TypeSpec.Builder builder, CdsDefinition def, Supplier<Boolean> doRead) {
        if (doRead.get().booleanValue()) {
            SpecWriterUtil.getJavaDoc((CdsAnnotatable)def).ifPresent(a -> builder.addJavadoc(a.replace("$", "$$"), new Object[0]));
        }
    }

    private static TypeSpec.Builder createInterfaceSpecBuilder(ClassName type) {
        return TypeSpec.interfaceBuilder((ClassName)type).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    private boolean isTargetAspect(CdsStructuredType struct) {
        return this.model.entities().flatMap(CdsStructuredType::associations).map(a -> ((CdsAssociationType)a.getType().as(CdsAssociationType.class)).getTargetAspect()).anyMatch(ta -> ta.isPresent() && ((CdsStructuredType)ta.get()).getName().equals(struct.getName()));
    }

    private void writeType(String packageName, TypeSpec typeSpec) {
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
        final JavaFileObject fileObject = javaFile.toJavaFileObject();
        GeneratedFile jpaFile = new GeneratedFile(){

            @Override
            public URI getUri() {
                return fileObject.toUri();
            }

            @Override
            public InputStream getContent() throws IOException {
                return fileObject.openInputStream();
            }
        };
        try {
            this.consumer.accept(jpaFile);
        }
        catch (IOException e) {
            String message = "Exception while writing to file %s.".formatted(jpaFile.getUri());
            throw new EntityWriterException(message, e);
        }
    }

    record Context(String tenantDiscriminator, Configuration config, NamesUtils namesUtils) {
        boolean isTenantDiscriminator(CdsElement element) {
            if (this.tenantDiscriminator == null || element == null) {
                return false;
            }
            return this.tenantDiscriminator.equals(element.getName());
        }
    }
}

