/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.util;

import com.sap.cds.generator.util.FileLocation;
import com.sap.cds.generator.util.GeneratedFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystem
implements GeneratedFile.Accessor {
    private final Logger logger = LoggerFactory.getLogger(FileSystem.class);
    private final Path baseDirectory;
    private final boolean mavenLayout;
    private final boolean overwrite;

    public FileSystem(Path baseDirectory, boolean mavenLayout) {
        this(baseDirectory, mavenLayout, true);
    }

    public FileSystem(Path baseDirectory, boolean mavenLayout, boolean overwrite) {
        this.mavenLayout = mavenLayout;
        this.overwrite = overwrite;
        File dir = baseDirectory.toFile();
        if (dir.exists() && !dir.isDirectory()) {
            String message = "'%s' is not a directory.".formatted(baseDirectory.getFileName());
            throw new IllegalArgumentException(message);
        }
        this.baseDirectory = baseDirectory;
    }

    @Override
    public void accept(GeneratedFile file) throws IOException {
        block17: {
            try {
                Path outputPath = this.getPath(file);
                if (Files.exists(outputPath, new LinkOption[0])) {
                    if (!this.overwrite) {
                        this.logger.info("Class {} already exists. No new handler is generated.", (Object)outputPath.getFileName());
                        break block17;
                    }
                    try (SeekableByteChannel rbc = Files.newByteChannel(outputPath, new OpenOption[0]);
                         InputStream in = Channels.newInputStream(rbc);){
                        if (!IOUtils.contentEquals((InputStream)file.getContent(), (InputStream)in)) {
                            Files.copy(file.getContent(), outputPath, StandardCopyOption.REPLACE_EXISTING);
                        }
                        break block17;
                    }
                }
                Files.createDirectories(outputPath.toFile().getParentFile().toPath(), new FileAttribute[0]);
                Files.copy(file.getContent(), outputPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                String message = "Error writing file '%s' to file system.".formatted(file.getUri());
                throw new IOException(message, e);
            }
        }
    }

    private Path getPath(FileLocation location) {
        Path base = this.getBase(location);
        return base.resolve(location.getUri().getPath());
    }

    private Path getBase(FileLocation location) {
        if (!this.mavenLayout) {
            return this.baseDirectory;
        }
        return this.baseDirectory.resolve(location.isResource() ? "resources" : "java");
    }

    @Override
    public GeneratedFile get(final FileLocation location) throws IOException {
        final Path path = this.getPath(location);
        return new GeneratedFile(){

            @Override
            public URI getUri() {
                return location.getUri();
            }

            @Override
            public InputStream getContent() throws IOException {
                if (!path.toFile().exists()) {
                    return null;
                }
                return Files.newInputStream(path, new OpenOption[0]);
            }
        };
    }
}

