/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator;

import com.sap.cds.generator.Cds4jCodegenRunner;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.CsnSupplier;
import com.sap.cds.generator.Result;
import com.sap.cds.generator.util.GeneratedFile;
import com.sap.cds.generator.writer.ModelWriter;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollector;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollectorFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cds4jCodegen {
    private static final Logger logger = LoggerFactory.getLogger(Cds4jCodegen.class);
    private static final IssueCollector issueCollector = IssueCollectorFactory.getIssueCollector(Cds4jCodegen.class);
    private final Configuration configuration;

    public Cds4jCodegen(Configuration configuration) {
        this.configuration = configuration;
    }

    public Result generate(CsnSupplier csn, GeneratedFile.Consumer consumer) {
        Cds4jCodegenRunner helper = new Cds4jCodegenRunner(logger, issueCollector);
        return helper.generate(csn, (CdsModel model) -> this.generate(model, consumer));
    }

    private Result.Status generate(CdsModel cdsModel, GeneratedFile.Consumer consumer) throws IOException {
        if (Cds4jCodegenRunner.noRelevantIssues(this.configuration.getParserMode(), this.configuration.getGeneratorMode())) {
            ModelWriter visitor = new ModelWriter(consumer, this.configuration, cdsModel);
            cdsModel.accept((CdsVisitor)visitor);
            Cds4jCodegen.writeMetaInf(visitor, consumer);
            return Result.Status.SUCCESS;
        }
        return Result.Status.FAILURE;
    }

    private static void writeMetaInf(ModelWriter visitor, GeneratedFile.Consumer consumer) throws IOException {
        if (!visitor.getGeneratedServices().isEmpty()) {
            final StringBuilder builder = new StringBuilder();
            visitor.getGeneratedServices().forEach(fqnService -> builder.append((String)fqnService).append("\n"));
            consumer.accept(new GeneratedFile(){

                @Override
                public URI getUri() {
                    return URI.create("META-INF/cds4j-codegen/services.generated");
                }

                @Override
                public InputStream getContent() {
                    return new ByteArrayInputStream(builder.toString().getBytes(StandardCharsets.UTF_8));
                }

                @Override
                public boolean isResource() {
                    return true;
                }
            });
        }
    }
}

