/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.palantir.javapoet.AnnotationSpec;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.FieldSpec;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeName;
import com.palantir.javapoet.TypeSpec;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.writer.ModelWriter;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.generator.writer.Types;
import com.sap.cds.ql.CdsName;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBuilderInterfaceVisitor
implements CdsVisitor {
    private static final Logger logger = LoggerFactory.getLogger(CreateBuilderInterfaceVisitor.class);
    private static final String FILTER = "filter";
    private final TypeSpec.Builder entityClass;
    private final Configuration cfg;
    private final ClassName builderClassName;
    private final ClassName entityClassName;
    private final ModelWriter.Context context;

    CreateBuilderInterfaceVisitor(TypeSpec.Builder builder, ClassName builderClassName, ClassName entityClassName, ModelWriter.Context context) {
        this.entityClass = builder;
        this.context = context;
        this.cfg = context.config();
        this.builderClassName = builderClassName;
        this.entityClassName = entityClassName;
    }

    public void visit(CdsEntity entity) {
        this.generateInterface((CdsType)entity);
    }

    public void visit(CdsEvent event) {
        this.generateInterface((CdsType)event);
    }

    public void visit(CdsStructuredType struct) {
        this.generateInterface((CdsType)struct);
    }

    public void visit(CdsElement attribute) {
        if (this.context.isTenantDiscriminator(attribute)) {
            return;
        }
        if (attribute.getType().isStructured()) {
            this.addStructuredAttribute(attribute);
        } else if (attribute.getType().isAssociation()) {
            this.addAssociationAttribute(attribute);
        } else {
            this.addAttribute(attribute);
        }
    }

    private void generateInterface(CdsType def) {
        ClassName innerBuilderClassName = NamesUtils.suffixedClassName(this.context.config(), def);
        this.entityClass.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Types.STRUCTURED_TYPE, (TypeName[])new TypeName[]{innerBuilderClassName}));
        this.entityClass.addAnnotation(AnnotationSpec.builder(CdsName.class).addMember("value", "$S", new Object[]{def.getQualifiedName()}).build());
        this.addStaticQualifiedAttribute((CdsDefinition)def);
    }

    private void addStructuredAttribute(CdsElement attribute) {
        if (!TypeUtils.isIgnored((CdsAnnotatable)attribute)) {
            ClassName returnType;
            if (((CdsStructuredType)attribute.getType().as(CdsStructuredType.class)).isAnonymous()) {
                Stream elements = ((CdsStructuredType)attribute.getType().as(CdsStructuredType.class)).elements();
                ClassName innerInterfaceName = NamesUtils.suffixedClassName(this.cfg, this.builderClassName, attribute);
                this.addInnerInterface(innerInterfaceName, NamesUtils.className(this.cfg, this.entityClassName, attribute), elements);
                returnType = innerInterfaceName;
            } else {
                returnType = NamesUtils.suffixedClassName(this.cfg, (CdsType)attribute.getType().as(CdsStructuredType.class));
            }
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)NamesUtils.methodName(this.cfg, attribute)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)returnType);
            if (SpecWriterUtil.addCdsNameAnnotation(this.cfg, methodBuilder, attribute)) {
                SpecWriterUtil.addStaticField(this.entityClass, attribute);
            }
            this.entityClass.addMethod(methodBuilder.build());
        }
    }

    private void addInnerInterface(ClassName interfaceName, ClassName entityClassName, Stream<CdsElement> elements) {
        TypeSpec.Builder innerInterfaceBuilder = TypeSpec.interfaceBuilder((ClassName)interfaceName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        innerInterfaceBuilder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)Types.STRUCTURED_TYPE, (TypeName[])new TypeName[]{interfaceName}));
        CreateBuilderInterfaceVisitor visitor = new CreateBuilderInterfaceVisitor(innerInterfaceBuilder, interfaceName, entityClassName, this.context);
        elements.forEach(e -> e.accept((CdsVisitor)visitor));
        this.entityClass.addType(innerInterfaceBuilder.build());
    }

    private void addStaticQualifiedAttribute(CdsDefinition def) {
        String qualifiedName = def.getQualifiedName();
        FieldSpec staticField = FieldSpec.builder(String.class, (String)"CDS_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{qualifiedName}).build();
        this.entityClass.addField(staticField);
    }

    private void addAssociationAttribute(CdsElement attribute) {
        if (TypeUtils.isAnonymousAspect(attribute)) {
            this.addInnerInterface(NamesUtils.suffixedClassName(this.cfg, this.builderClassName, attribute), NamesUtils.className(this.cfg, this.entityClassName, attribute), TypeUtils.getAnonymousElements(attribute));
        }
        this.addMainFunction(attribute);
        this.addFilterFunction(attribute);
    }

    private void addAttribute(CdsElement attribute) {
        if (!TypeUtils.isIgnored((CdsAnnotatable)attribute)) {
            ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)Types.REFERENCE, (TypeName[])new TypeName[]{TypeUtils.getReturnType(this.entityClassName, attribute, this.cfg)});
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)NamesUtils.rawName(attribute)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)returnType);
            if (SpecWriterUtil.addCdsNameAnnotation(this.cfg, methodBuilder, attribute)) {
                SpecWriterUtil.addStaticField(this.entityClass, attribute);
            }
            this.entityClass.addMethod(methodBuilder.build());
        }
    }

    private void addMainFunction(CdsElement attribute) {
        ClassName returnType = this.getTargetName(attribute);
        if (!TypeUtils.isIgnored((CdsAnnotatable)attribute)) {
            this.entityClass.addMethod(MethodSpec.methodBuilder((String)NamesUtils.rawName(attribute)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)returnType).build());
        } else {
            logger.error("Unable to generate method %s for %s".formatted(attribute.getName(), returnType));
        }
    }

    private void addFilterFunction(CdsElement attribute) {
        if (!attribute.getName().equalsIgnoreCase(FILTER)) {
            ClassName returnType = this.getTargetName(attribute);
            if (!TypeUtils.isIgnored((CdsAnnotatable)attribute)) {
                this.entityClass.addMethod(MethodSpec.methodBuilder((String)NamesUtils.rawName(attribute)).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Types.FUNCTION, (TypeName[])new TypeName[]{returnType, Types.PREDICATE}), FILTER, new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)returnType).build());
            } else {
                logger.error("Unable to generate filter method %s for %s".formatted(attribute.getName(), returnType));
            }
        } else {
            logger.warn("There is a name clash between the element 'filter' of entity '%s' and a method in the super interface StructuredType. A filter function accepting predicates will not be generated.\n".formatted(this.builderClassName.simpleName()));
        }
    }

    public ClassName getTargetName(CdsElement element) {
        CdsAssociationType association = (CdsAssociationType)element.getType();
        CdsType target = (CdsType)association.getTargetAspect().orElseGet(() -> ((CdsAssociationType)association).getTarget());
        if (target.getQualifiedName().isEmpty()) {
            return NamesUtils.suffixedClassName(this.cfg, this.builderClassName, element);
        }
        return NamesUtils.suffixedClassName(this.cfg, target);
    }
}

