/************************************************************************
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.generator;

import com.google.common.collect.Lists;
import com.sap.cds.reflect.impl.reader.issuecollector.Issue;

import java.util.Collection;
import java.util.Collections;

public class Result {
	final Collection<Issue> issues = Lists.newLinkedList();
	Status status = Status.FAILURE;

	public Status getStatus() {
		return status;
	}

	public Collection<Issue> getIssues() {
		return Collections.unmodifiableCollection(issues);
	}

	public enum Status {
		SUCCESS, FAILURE
	}
}
