/************************************************************************
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.generator.util;

import java.util.Locale;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.google.common.base.CaseFormat;

public class CaseFormatHelper {

	private CaseFormatHelper() {
	}

	public static String lowercaseFirst(String s) {
		char[] c = s.toCharArray();
		c[0] = Character.toLowerCase(c[0]);
		return new String(c);
	}

	static String toUpperCamel(String name) {
		return convert(name.replace(".", "_"), CaseFormat.LOWER_CAMEL, CaseFormat.UPPER_CAMEL);
	}

	static String toLowerCamel(String name) {
		return convert(name, CaseFormat.UPPER_CAMEL, CaseFormat.LOWER_CAMEL);
	}

	public static String toUpperUnderscore(String name) {
		if (isUppercaseOnly(name)) {
			return name;
		}
		String convertedString = new PropertyNamingStrategies.SnakeCaseStrategy().translate(name);
		return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_UNDERSCORE, convertedString).replaceAll("_+", "_");
	}

	private static String convert(String name, CaseFormat sourceFormat, CaseFormat targetFormat) {
		// if true : GET_TEST_CASE_ACTION_WITH_FILTER        -> GetTestCaseActionWithFilter
		// if false: GET_TEST_CASE_ACTION_WITH_FILTERContext -> GETTestCaseActionWithFILTERContext,
		//                                     but should be -> GetTestCaseActionWithFilterContext
		// TODO: fix wrong conversion, will be incompatible
		if (isUppercaseOnly(name)) {
			return CaseFormat.UPPER_UNDERSCORE.to(targetFormat, name);
		}
		if (!name.contains("_")) {
			return sourceFormat.to(targetFormat, name);
		}
		String[] parts = name.split("_");
		StringBuilder lowerCamel = new StringBuilder(sourceFormat.to(targetFormat, parts[0]));
		for (int i = 1; i < parts.length; i++) {
			lowerCamel.append(toUpperCamel(parts[i]));
		}
		return lowerCamel.toString();
	}

	public static boolean isUppercaseOnly(String name) {
		return name.equals(name.toUpperCase(Locale.US)); // NOSONAR
	}

}
