/************************************************************************
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.generator.util;

import java.util.regex.Pattern;

class PatternMatcher {

	private PatternMatcher() {
		// hidden
	}

	private static final String DOT = "\\.";
	private static final String CHAR = "[^\\.]";
	private static final String CHARS = many(CHAR);
	private static final String PATH = CHARS + DOT;
	private static final String PATHS = many(PATH);

	static Pattern transformPattern(String pattern) {
		if (pattern.endsWith("**")) {
			pattern += ".*"; // TODO - is this invalid?
		}
		char[] chars = pattern.toCharArray();
		int length = pattern.length();
		StringBuilder regex = new StringBuilder();
		for (int i = 0; i < length; i++) {
			char c = chars[i];
			switch (c) {
			case '.':
				regex.append(DOT);
				break;
			case '*':
				if (pattern.indexOf("**.", i) == i) {
					regex.append(PATHS);
					i += 2;
				} else {
					regex.append(CHARS);
				}
				break;
			default:
				regex.append(c);
			}
		}
		regex.append("$");

		return Pattern.compile(regex.toString());
	}

	private static String many(String pattern) {
		return "(" + pattern + ")*";
	}
}
