/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator;

import com.sap.cds.generator.CsnSupplier;
import com.sap.cds.generator.Result;
import com.sap.cds.generator.util.GeneratorMode;
import com.sap.cds.generator.util.ParserMode;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.impl.CdsModelReader;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollector;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollectorFactory;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import org.slf4j.Logger;

class Cds4jCodegenRunner {
    private final Logger logger;
    private final IssueCollector issueCollector;

    Cds4jCodegenRunner(Logger logger, IssueCollector issueCollector) {
        this.logger = logger;
        this.issueCollector = issueCollector;
    }

    Result generate(CsnSupplier csn, Generator generator) {
        IssueCollectorFactory.clearIssues();
        IssueCollectorFactory.enableUnrecognizedLogging();
        Result result = new Result();
        try {
            CdsModelReader.Config config = new CdsModelReader.Config.Builder().setReadDocs(true).build();
            CdsModel cdsModel = CdsModelReader.read((CdsModelReader.Config)config, (String)new String(csn.get(), StandardCharsets.UTF_8), (boolean)false);
            result.status = generator.apply(cdsModel);
        }
        catch (NoSuchFileException e) {
            String msg = "CSN file not found: ";
            this.logger.debug(msg, (Throwable)e);
            this.issueCollector.critical("", msg + e.getFile(), new Object[0]);
        }
        catch (Throwable t) {
            this.logger.error("Stopped execution due to exception: ", t);
            this.issueCollector.critical("", t.getMessage(), new Object[0]);
        }
        result.issues.addAll(IssueCollectorFactory.getIssues());
        return result;
    }

    static boolean noRelevantIssues(ParserMode parserMode, GeneratorMode generatorMode) {
        if (IssueCollectorFactory.hasIssues((IssueType)IssueType.CRITICAL)) {
            return false;
        }
        if (parserMode == ParserMode.STRICT && IssueCollectorFactory.hasIssues((IssueType)IssueType.UNRECOGNIZED)) {
            return false;
        }
        if (generatorMode == GeneratorMode.STRICT) {
            if (IssueCollectorFactory.hasIssues((IssueType)IssueType.ERROR)) {
                return false;
            }
            return !IssueCollectorFactory.hasIssues((IssueType)IssueType.UNSUPPORTED);
        }
        return true;
    }

    @FunctionalInterface
    static interface Generator {
        public Result.Status apply(CdsModel var1) throws IOException;
    }
}

