/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.util;

import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.EntityWriterException;
import com.sap.cds.generator.util.GeneratedFile;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.writer.Types;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsOperation;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsAnnotatableImpl;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeUtils {
    private static final Logger logger = LoggerFactory.getLogger(TypeUtils.class);
    private static final ParameterizedTypeName MAP_STR2OBJ = ParameterizedTypeName.get((ClassName)Types.MAP, (TypeName[])new TypeName[]{Types.STRING, Types.OBJECT});

    private TypeUtils() {
    }

    public static TypeName getAttributeType(ClassName parent, CdsType type, Configuration cfg) {
        return TypeUtils.getAttributeType(parent, type, cfg, null);
    }

    private static TypeName getAttributeType(ClassName parent, CdsType type, Configuration cfg, CdsElement element) {
        TypeName attributeType = null;
        if (type.isAssociation()) {
            CdsAssociationType assocType = (CdsAssociationType)type.as(CdsAssociationType.class);
            Object target = null;
            if (cfg.getInterfacesForAspects()) {
                target = assocType.getTarget() != null ? assocType.getTarget() : (CdsType)assocType.getTargetAspect().orElse(null);
            } else if (!cfg.getInterfacesForAspects()) {
                target = (CdsType)assocType.getTargetAspect().orElse(assocType.getTarget());
            }
            if (target != null) {
                attributeType = NamesUtils.className(cfg, (CdsType)target);
                if (!CdsModelUtils.isSingleValued((CdsType)type)) {
                    attributeType = TypeUtils.listOf(attributeType);
                }
            }
        } else if (type.isSimple()) {
            CdsSimpleType simpleType = (CdsSimpleType)type.as(CdsSimpleType.class);
            attributeType = TypeName.get((Type)simpleType.getJavaType());
        } else if (type.isStructured()) {
            attributeType = type.getQualifiedName().isEmpty() ? null : NamesUtils.className(cfg, type);
        } else if (type.isArrayed()) {
            attributeType = element != null ? TypeUtils.arrayedTypeNameForElement(parent, (CdsArrayedType)type.as(CdsArrayedType.class), cfg, element) : TypeUtils.arrayedTypeNameForParameter((CdsArrayedType)type.as(CdsArrayedType.class), cfg);
        } else {
            logger.warn("Interface Generation: Unsupported CDS Element with attribute name '{}' and type '{}'.", (Object)type.getName(), (Object)type);
            return null;
        }
        return attributeType;
    }

    public static TypeName getReturnType(ClassName parent, CdsElement attribute, Configuration cfg) {
        boolean isMedia = attribute.annotations().anyMatch(a -> "Core.MediaType".equals(a.getName()));
        if (isMedia && attribute.getType().isSimple()) {
            CdsSimpleType simpleType = (CdsSimpleType)attribute.getType().as(CdsSimpleType.class);
            return ClassName.get((Class)CdsBaseType.cdsJavaMediaType((CdsBaseType)simpleType.getType()));
        }
        if (attribute.getType().isStructured() && attribute.getType().getQualifiedName().isEmpty()) {
            return NamesUtils.className(parent, attribute);
        }
        if (TypeUtils.isAnonymousAspect(attribute)) {
            ClassName attributeType = NamesUtils.className(parent, attribute);
            if (!CdsModelUtils.isSingleValued((CdsType)attribute.getType())) {
                attributeType = TypeUtils.listOf((TypeName)attributeType);
            }
            return attributeType;
        }
        return TypeUtils.getAttributeType(parent, attribute.getType(), cfg, attribute);
    }

    public static TypeName getOperationResultType(CdsEntity boundTo, CdsOperation operation, CdsType returnType, Configuration config) {
        if (TypeUtils.isAnonymousType(returnType, config)) {
            ClassName innerEventContextClassName = NamesUtils.eventContextClassName(config, boundTo, (CdsDefinition)operation).nestedClass("ReturnType");
            if (returnType.isArrayed()) {
                return TypeUtils.getArrayTypeName((TypeName)innerEventContextClassName);
            }
            return innerEventContextClassName;
        }
        if (returnType.isStructured()) {
            return NamesUtils.className(config, returnType);
        }
        if (returnType.isSimple()) {
            CdsSimpleType type = (CdsSimpleType)returnType.as(CdsSimpleType.class);
            return TypeName.get((Type)type.getJavaType());
        }
        if (returnType.isArrayed()) {
            if (config.getSharedInterfaces() && TypeUtils.isAnonymousType(returnType)) {
                ClassName className = NamesUtils.className(config, returnType);
                return TypeUtils.getAttributeType(className, returnType, config, null);
            }
            TypeName nestedType = TypeUtils.getOperationResultType(boundTo, operation, ((CdsArrayedType)returnType.as(CdsArrayedType.class)).getItemsType(), config);
            return ParameterizedTypeName.get((ClassName)Types.COLLECTION, (TypeName[])new TypeName[]{nestedType});
        }
        logger.warn("Consumption Interface Generation: Unsupported CDS Element with attribute name {} and type {}", (Object)operation.getName(), (Object)returnType.getName());
        return null;
    }

    public static ParameterizedTypeName listOf(TypeName type) {
        return ParameterizedTypeName.get((ClassName)Types.LIST, (TypeName[])new TypeName[]{type});
    }

    public static boolean isAnonymousAspect(CdsElement element) {
        Optional targetAspect;
        CdsType type = element.getType();
        return type.isAssociation() && (targetAspect = ((CdsAssociationType)type.as(CdsAssociationType.class)).getTargetAspect()).isPresent() && ((CdsStructuredType)targetAspect.get()).getQualifiedName().isEmpty();
    }

    public static boolean isAnonymousType(CdsType type, Configuration config) {
        if (type.isArrayed()) {
            boolean isTypeAnonymous = TypeUtils.isAnonymousType(type);
            if (config.getSharedInterfaces()) {
                return isTypeAnonymous && type.getQualifiedName().isEmpty();
            }
            return isTypeAnonymous;
        }
        return TypeUtils.isAnonymousType(type);
    }

    public static boolean isAnonymousType(CdsType type) {
        if (type == null) {
            return false;
        }
        if (type.isArrayed()) {
            return TypeUtils.isAnonymousType(((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType());
        }
        return type.isStructured() && type.getQualifiedName().isEmpty();
    }

    public static Stream<CdsElement> getAnonymousElements(CdsElement element) {
        Optional targetAspect;
        CdsType type = element.getType();
        if (type.isAssociation() && (targetAspect = ((CdsAssociationType)type.as(CdsAssociationType.class)).getTargetAspect()).isPresent() && ((CdsStructuredType)targetAspect.get()).getQualifiedName().isEmpty()) {
            return ((CdsStructuredType)((CdsStructuredType)targetAspect.get()).as(CdsStructuredType.class)).elements();
        }
        return Stream.empty();
    }

    public static void addStaticFactoryMethods(TypeSpec.Builder builder, TypeName returnType, TypeSpec.Builder ... anonymousbuilder) {
        MethodSpec.Builder createMethodBuilder = MethodSpec.methodBuilder((String)"create").returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        CodeBlock.Builder createCodeBuilder = CodeBlock.builder();
        createCodeBuilder.addStatement("return $T.create($T.class)", new Object[]{Types.STRUCT, returnType});
        createMethodBuilder.addCode(createCodeBuilder.build());
        MethodSpec.Builder ofMethodBuilder = MethodSpec.methodBuilder((String)"of").returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(ParameterSpec.builder((TypeName)MAP_STR2OBJ, (String)"map", (Modifier[])new Modifier[0]).build());
        CodeBlock.Builder ofCodeBuilder = CodeBlock.builder();
        ofCodeBuilder.addStatement("return $T.access(map).as($T.class)", new Object[]{Types.STRUCT, returnType});
        ofMethodBuilder.addCode(ofCodeBuilder.build());
        if (anonymousbuilder.length > 0) {
            anonymousbuilder[0].addMethod(createMethodBuilder.build());
            anonymousbuilder[0].addMethod(ofMethodBuilder.build());
        } else {
            builder.addMethod(createMethodBuilder.build());
            builder.addMethod(ofMethodBuilder.build());
        }
    }

    public static void addStaticCreateForKeys(TypeSpec.Builder builder, ClassName entity, Map<String, ParameterSpec> parameters) {
        if (!parameters.isEmpty()) {
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"create").returns((TypeName)entity).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
            parameters.forEach((name, spec) -> methodBuilder.addParameter(spec));
            CodeBlock.Builder codeBuilder = CodeBlock.builder();
            codeBuilder.addStatement("$T<String, Object> keys = new $T<>()", new Object[]{Types.MAP, Types.HASH_MAP});
            parameters.forEach((name, spec) -> codeBuilder.addStatement("keys.put($L, $L)", new Object[]{name, spec.name}));
            codeBuilder.addStatement("return $T.access(keys).as($T.class)", new Object[]{Types.STRUCT, entity});
            methodBuilder.addCode(codeBuilder.build());
            builder.addMethod(methodBuilder.build());
        }
    }

    public static List<CdsElement> getManagedToOneFks(CdsElement attribute) {
        return new OnConditionAnalyzer(attribute, false).getFkMapping().keySet().stream().map(m -> ((CdsStructuredType)attribute.getDeclaringType().as(CdsStructuredType.class)).findElement(m)).map(Optional::get).toList();
    }

    public static void logWarningForManyToManyWithStructElement(CdsModel model, CdsStructuredType struct) {
        Optional<CdsElement> assocElement;
        if (struct.elements().anyMatch(e -> e.getType().isStructured()) && (assocElement = model.entities().flatMap(CdsStructuredType::associations).filter(a -> ((CdsAssociationType)a.getType().as(CdsAssociationType.class)).getTargetAspect().map(ta -> ta.getName().equals(struct.getName())).orElse(false)).findFirst()).isPresent()) {
            logger.warn("Limited CRUD operation support available with composition of aspects({}) containing structured elements. Use dynamic queries in such cases.", (Object)struct.getQualifiedName());
        }
    }

    private static TypeName arrayedTypeNameForParameter(CdsArrayedType type, Configuration cfg) {
        CdsType itemsType = type.getItemsType();
        if (itemsType.isSimple()) {
            return TypeUtils.getArrayTypeName(TypeName.get((Type)((CdsSimpleType)itemsType.as(CdsSimpleType.class)).getJavaType()));
        }
        ClassName javaClassName = null;
        if (!type.getQualifiedName().isEmpty() && itemsType.getQualifiedName().isEmpty()) {
            return TypeUtils.getArrayTypeName((TypeName)NamesUtils.className(cfg, (CdsType)type).nestedClass("Item"));
        }
        if (!itemsType.getQualifiedName().isEmpty()) {
            javaClassName = NamesUtils.className(cfg, itemsType);
        }
        if (javaClassName == null) {
            logger.error("Interface Generation: Unsupported combination of empty type and items type for function/action parameter.");
            return null;
        }
        return TypeUtils.getArrayTypeName((TypeName)javaClassName);
    }

    private static TypeName arrayedTypeNameForElement(ClassName parent, CdsArrayedType type, Configuration cfg, CdsElement element) {
        CdsType itemsType = type.getItemsType();
        TypeName innerAttributeType = TypeUtils.getAttributeType(parent, itemsType, cfg, element);
        if (innerAttributeType == null) {
            if (type.getQualifiedName().startsWith(element.getDeclaringType().getQualifiedName())) {
                return TypeUtils.getArrayTypeName((TypeName)NamesUtils.className(parent, element));
            }
            return TypeUtils.getArrayTypeName((TypeName)NamesUtils.className(cfg, (CdsType)type).nestedClass("Item"));
        }
        return TypeUtils.getArrayTypeName(innerAttributeType);
    }

    public static TypeName getArrayTypeName(TypeName javaType) {
        return ParameterizedTypeName.get((ClassName)Types.COLLECTION, (TypeName[])new TypeName[]{javaType});
    }

    public static void writeType(String packageName, TypeSpec typeSpec, GeneratedFile.Consumer consumer) {
        JavaFile javaFile = JavaFile.builder((String)packageName, (TypeSpec)typeSpec).build();
        final JavaFileObject fileObject = javaFile.toJavaFileObject();
        GeneratedFile generatedFile = new GeneratedFile(){

            @Override
            public URI getUri() {
                return fileObject.toUri();
            }

            @Override
            public InputStream getContent() throws IOException {
                return fileObject.openInputStream();
            }
        };
        try {
            consumer.accept(generatedFile);
        }
        catch (IOException e) {
            String message = "Exception while writing to file %s.".formatted(generatedFile.getUri());
            throw new EntityWriterException(message, e);
        }
    }

    public static boolean isIgnored(CdsAnnotatable def) {
        String cdsJavaIgnore = CdsAnnotatableImpl.removeAt((String)"@cds.java.ignore");
        return (Boolean)def.getAnnotationValue(cdsJavaIgnore, (Object)false);
    }
}

