/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.MethodStyle;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.writer.ModelWriter;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.generator.writer.Types;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.CdsEventBuilder;
import com.sap.cds.util.CdsModelUtils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public class CreateConsumptionInterfaceVisitor
implements CdsVisitor {
    private static final ParameterizedTypeName MAP_STR2OBJ = ParameterizedTypeName.get((ClassName)Types.MAP, (TypeName[])new TypeName[]{Types.STRING, WildcardTypeName.subtypeOf(Object.class)});
    private final TypeSpec.Builder builder;
    private final Configuration cfg;
    private final ClassName className;
    private final ModelWriter.Context context;
    private final Set<String> parentElements;

    CreateConsumptionInterfaceVisitor(TypeSpec.Builder builder, ClassName className, ModelWriter.Context context, Collection<CdsStructuredType> parents) {
        this.builder = builder;
        this.cfg = context.config();
        this.className = className;
        this.context = context;
        this.parentElements = parents.stream().flatMap(t -> t.elements().filter(CreateConsumptionInterfaceVisitor::isAnonymousType).map(CdsElementDefinition::getName)).collect(Collectors.toSet());
        if (!builder.superinterfaces.contains(Types.CDS_DATA)) {
            this.builder.addSuperinterface((TypeName)Types.CDS_DATA);
        }
    }

    public void visit(CdsEntity entity) {
        ClassName javaName = NamesUtils.className(this.cfg, (CdsType)entity);
        this.addRefMethod(entity);
        TypeUtils.addStaticFactoryMethods(this.builder, (TypeName)javaName, new TypeSpec.Builder[0]);
        LinkedHashMap<String, ParameterSpec> keyElements = new LinkedHashMap<String, ParameterSpec>();
        entity.keyElements().filter(k -> !TypeUtils.isIgnored((CdsAnnotatable)k)).forEach(key -> keyElements.put(NamesUtils.constantName(key), ParameterSpec.builder((TypeName)this.getSetterParam((CdsElement)key), (String)NamesUtils.argumentName(key), (Modifier[])new Modifier[0]).build()));
        if (keyElements.size() == 1) {
            TypeUtils.addStaticCreateForKeys(this.builder, javaName, keyElements);
        }
        this.builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(entity.getQualifiedName(), "$S"));
    }

    public void visit(CdsEvent event) {
        TypeUtils.addStaticFactoryMethods(this.builder, (TypeName)this.className, new TypeSpec.Builder[0]);
        this.builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(event.getQualifiedName(), "$S"));
    }

    public void visit(CdsStructuredType struct) {
        TypeUtils.addStaticFactoryMethods(this.builder, (TypeName)NamesUtils.className(this.cfg, (CdsType)struct), new TypeSpec.Builder[0]);
        this.builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(struct.getQualifiedName(), "$S"));
    }

    public void visit(CdsArrayedType type) {
        if (!type.getQualifiedName().isEmpty() && type.getItemsType().isStructured() && type.getItemsType().getQualifiedName().isEmpty() && !type.getItemsType().isSimple()) {
            this.builder.superinterfaces.clear();
            ClassName itemsInterfaceName = this.className.nestedClass("Item");
            TypeSpec.Builder innerIntefaceBuilder = TypeSpec.interfaceBuilder((ClassName)itemsInterfaceName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
            ((CdsStructuredType)type.getItemsType().as(CdsStructuredType.class)).elements().forEach(e -> e.accept((CdsVisitor)new CreateConsumptionInterfaceVisitor(innerIntefaceBuilder, this.className.nestedClass("Item"), this.context, Set.of())));
            TypeUtils.addStaticFactoryMethods(this.builder, (TypeName)itemsInterfaceName, innerIntefaceBuilder);
            this.builder.addType(innerIntefaceBuilder.build());
        }
    }

    public void visit(CdsElement element) {
        if (this.context.isTenantDiscriminator(element)) {
            return;
        }
        SpecWriterUtil.addStaticField(this.builder, element);
        if (CreateConsumptionInterfaceVisitor.isAnonymousType(element) && !this.parentElements.contains(element.getName())) {
            ClassName elementName = NamesUtils.className(this.className, element);
            TypeName returnType = TypeUtils.getReturnType(this.className, element, this.cfg);
            TypeSpec.Builder innerIntefaceBuilder = TypeSpec.interfaceBuilder((ClassName)elementName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
            CdsType type = element.getType();
            Stream elements = type.isStructured() && type.getQualifiedName().isEmpty() ? ((CdsStructuredType)type.as(CdsStructuredType.class)).elements() : (type.isArrayed() ? ((CdsStructuredType)((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType().as(CdsStructuredType.class)).elements() : TypeUtils.getAnonymousElements(element));
            elements.forEach(e -> e.accept((CdsVisitor)new CreateConsumptionInterfaceVisitor(innerIntefaceBuilder, elementName, this.context, Set.of())));
            TypeUtils.addStaticFactoryMethods(this.builder, (TypeName)elementName, innerIntefaceBuilder);
            this.populateGetter(element, returnType, false);
            this.populateSetter(element, returnType, false);
            this.builder.addType(innerIntefaceBuilder.build());
        } else {
            this.getter(element);
            this.setter(element);
        }
        if (this.cfg.fkAccessors() && CdsModelUtils.managedToOne((CdsType)element.getType()) && !element.getName().equals("DraftAdministrativeData")) {
            SpecWriterUtil.addFkStaticField(this.builder, element);
            this.addFkMethods(element);
        }
    }

    private void addRefMethod(CdsEntity entity) {
        if (!entity.isAbstract()) {
            ClassName returnType = NamesUtils.suffixedClassName(this.context.config(), (CdsType)entity);
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"ref").returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            this.builder.addMethod(methodBuilder.build());
        }
    }

    private void setter(CdsElement attribute) {
        TypeName paramType = this.getSetterParam(attribute);
        if (paramType == null) {
            return;
        }
        this.populateSetter(attribute, paramType, false);
    }

    private void populateSetter(CdsElement attribute, TypeName paramType, boolean cdsPath) {
        if (!TypeUtils.isIgnored((CdsAnnotatable)attribute)) {
            String setter;
            TypeName returnType;
            if (this.cfg.getMethodStyle() == MethodStyle.BEAN) {
                returnType = TypeName.VOID;
                setter = NamesUtils.setterName(attribute);
            } else {
                returnType = this.className;
                setter = NamesUtils.methodName(attribute);
            }
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)setter).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(paramType, NamesUtils.argumentName(attribute), new Modifier[0]);
            this.addJavaDoc(attribute, methodBuilder);
            if (cdsPath) {
                SpecWriterUtil.addCdsPathAnnotation(methodBuilder, attribute.getName(), setter);
            } else {
                SpecWriterUtil.addCdsNameAnnotation(methodBuilder, attribute);
            }
            this.builder.addMethod(methodBuilder.build());
        }
    }

    private TypeName getSetterParam(CdsElement element) {
        if (!this.cfg.getStrictSetters() && element.getType().isAssociation()) {
            if (CdsModelUtils.isSingleValued((CdsType)element.getType())) {
                return MAP_STR2OBJ;
            }
            return TypeUtils.listOf((TypeName)WildcardTypeName.subtypeOf((TypeName)MAP_STR2OBJ));
        }
        return TypeUtils.getReturnType(this.className, element, this.cfg);
    }

    private void getter(CdsElement attribute) {
        TypeName returnType = TypeUtils.getReturnType(this.className, attribute, this.cfg);
        if (returnType == null) {
            return;
        }
        this.populateGetter(attribute, returnType, false);
    }

    private void populateGetter(CdsElement attribute, TypeName returnType, boolean cdsPath) {
        if (!TypeUtils.isIgnored((CdsAnnotatable)attribute)) {
            String getter = this.cfg.getMethodStyle().equals((Object)MethodStyle.BEAN) ? NamesUtils.getterName(attribute) : NamesUtils.methodName(attribute);
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)getter).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            this.addJavaDoc(attribute, methodBuilder);
            if (cdsPath) {
                SpecWriterUtil.addCdsPathAnnotation(methodBuilder, attribute.getName(), getter);
            } else {
                SpecWriterUtil.addCdsNameAnnotation(methodBuilder, attribute);
            }
            this.builder.addMethod(methodBuilder.build());
        }
    }

    private void addJavaDoc(CdsElement attribute, MethodSpec.Builder methodBuilder) {
        if (!(attribute.getDeclaringType() instanceof CdsEventBuilder.EventProxy) && this.cfg.getDocs()) {
            SpecWriterUtil.setJavaDoc((CdsAnnotatable)attribute, methodBuilder);
        }
    }

    private void addFkMethods(CdsElement attribute) {
        TypeUtils.getManagedToOneFks(attribute).forEach(fkElement -> {
            if (this.context.isTenantDiscriminator((CdsElement)fkElement)) {
                return;
            }
            TypeName keyReturnType = TypeUtils.getReturnType(this.className, fkElement, this.cfg);
            if (keyReturnType == null) {
                return;
            }
            this.populateSetter((CdsElement)fkElement, keyReturnType, true);
            this.populateGetter((CdsElement)fkElement, keyReturnType, true);
        });
    }

    private static boolean isAnonymousType(CdsElement element) {
        CdsType type = element.getType();
        if (type.isArrayed()) {
            if (type.getQualifiedName().startsWith(element.getDeclaringType().getQualifiedName())) {
                CdsType itemsType = ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType();
                return itemsType.isStructured() && itemsType.getQualifiedName().isEmpty();
            }
            return false;
        }
        if (type.isStructured() && type.getQualifiedName().isEmpty()) {
            return true;
        }
        return TypeUtils.isAnonymousAspect(element);
    }
}

