/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.CaseFormatHelper;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.writer.ModelWriter;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.generator.writer.Types;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsBoundAction;
import com.sap.cds.reflect.CdsBoundFunction;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsOperation;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.reader.model.CdsConstants;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public class CreateAppServiceInterfaceVisitor
implements CdsVisitor {
    private static final String DRAFT_SUFFIX = "_drafts";
    private static final ClassName INNER_DRAFT = ClassName.get((String)"", (String)"Draft", (String[])new String[0]);
    private static final ClassName INNER_APPLICATION = ClassName.get((String)"", (String)"Application", (String[])new String[0]);
    private static final ClassName INNER_REMOTE = ClassName.get((String)"", (String)"Remote", (String[])new String[0]);
    private final TypeSpec.Builder builder;
    private final Configuration config;
    private final NamesUtils namesUtils;
    private final ClassName className;

    CreateAppServiceInterfaceVisitor(TypeSpec.Builder builder, ClassName className, ModelWriter.Context context) {
        this.builder = builder;
        this.className = className;
        this.config = context.config();
        this.namesUtils = context.namesUtils();
    }

    public void visit(CdsService service) {
        if (this.namesUtils.isExcluded(service.getQualifiedName()) || TypeUtils.isIgnored((CdsAnnotatable)service)) {
            return;
        }
        NamesUtils.warnOnJavaKeywords(service.getQualifiedName());
        this.builder.addSuperinterface((TypeName)Types.CQN_SERVICE);
        this.builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(NamesUtils.typedServiceBuilderName(this.config, service), "$T.CDS_NAME"));
        this.addInnerInterface(INNER_APPLICATION, new ClassName[]{Types.APPLICATION_SERVICE, this.className});
        this.addInnerInterface(INNER_REMOTE, new ClassName[]{Types.REMOTE_SERVICE, this.className});
        if (CreateAppServiceInterfaceVisitor.isServiceDraftEnabled(service)) {
            this.addInnerInterface(INNER_DRAFT, new ClassName[]{Types.DRAFT_SERVICE, this.className});
        }
        service.entities().forEach(entity -> entity.accept((CdsVisitor)this));
        service.actions().forEach(action -> action.accept((CdsVisitor)this));
        service.functions().forEach(function -> function.accept((CdsVisitor)this));
    }

    private void addInnerInterface(ClassName innerInterfaceName, ClassName[] superInterfaces) {
        TypeSpec.Builder innerInterfaceBuilder = TypeSpec.interfaceBuilder((ClassName)innerInterfaceName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        List.of(superInterfaces).forEach(arg_0 -> ((TypeSpec.Builder)innerInterfaceBuilder).addSuperinterface(arg_0));
        this.builder.addType(innerInterfaceBuilder.build());
    }

    public void visit(CdsEntity entity) {
        if (entity.getName().endsWith(DRAFT_SUFFIX) || this.namesUtils.isExcluded(entity.getQualifiedName()) || TypeUtils.isIgnored((CdsAnnotatable)entity)) {
            return;
        }
        NamesUtils.warnOnJavaKeywords(entity.getQualifiedName());
        entity.actions().forEach(action -> {
            if (CdsConstants.DRAFT_ACTIONS.contains(action.getName())) {
                return;
            }
            Optional<MethodSpec> method = this.buildOperationFacadeMethod((CdsOperation)action, action.returnType(), Optional.of(entity));
            method.ifPresent(arg_0 -> ((TypeSpec.Builder)this.builder).addMethod(arg_0));
        });
        entity.functions().forEach(function -> {
            Optional<MethodSpec> method = this.buildOperationFacadeMethod((CdsOperation)function, function.returnType(), Optional.of(entity));
            method.ifPresent(arg_0 -> ((TypeSpec.Builder)this.builder).addMethod(arg_0));
        });
    }

    public void visit(CdsFunction function) {
        if (this.namesUtils.isExcluded(function.getQualifiedName()) || TypeUtils.isIgnored((CdsAnnotatable)function)) {
            return;
        }
        Optional<MethodSpec> method = this.buildOperationFacadeMethod((CdsOperation)function, function.returnType(), Optional.empty());
        method.ifPresent(arg_0 -> ((TypeSpec.Builder)this.builder).addMethod(arg_0));
    }

    public void visit(CdsAction action) {
        if (this.namesUtils.isExcluded(action.getQualifiedName()) || TypeUtils.isIgnored((CdsAnnotatable)action)) {
            return;
        }
        Optional<MethodSpec> method = this.buildOperationFacadeMethod((CdsOperation)action, action.returnType(), Optional.empty());
        method.ifPresent(arg_0 -> ((TypeSpec.Builder)this.builder).addMethod(arg_0));
    }

    private Optional<MethodSpec> buildOperationFacadeMethod(CdsOperation operation, Optional<CdsType> cdsReturnType, Optional<CdsEntity> entityOpt) {
        NamesUtils.warnOnJavaKeywords(operation.getQualifiedName());
        if (TypeUtils.isIgnored((CdsAnnotatable)operation)) {
            return Optional.empty();
        }
        String methodName = NamesUtils.methodName(operation);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        ClassName eventContextClassName = NamesUtils.eventContextClassName(this.config, entityOpt.orElse(null), (CdsDefinition)operation);
        methodBuilder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(eventContextClassName.simpleName() + ".CDS_NAME", "$L"));
        if (cdsReturnType.isPresent()) {
            TypeName returnType = TypeUtils.getOperationResultType(entityOpt.orElse(null), operation, cdsReturnType.get(), this.config);
            methodBuilder.returns(returnType);
        }
        if (entityOpt.isPresent()) {
            CdsEntity entity = entityOpt.get();
            CdsParameter bindingParameter = null;
            if (operation instanceof CdsBoundAction) {
                CdsBoundAction action = (CdsBoundAction)operation;
                bindingParameter = action.getBindingParameter();
            } else if (operation instanceof CdsBoundFunction) {
                CdsBoundFunction function = (CdsBoundFunction)operation;
                bindingParameter = function.getBindingParameter();
            }
            String bindingParameterName = bindingParameter != null ? bindingParameter.getName() : "ref";
            ClassName builderType = NamesUtils.suffixedClassName(this.config, (CdsType)entity);
            ParameterSpec bindingParam = ParameterSpec.builder((TypeName)builderType, (String)bindingParameterName, (Modifier[])new Modifier[0]).build();
            methodBuilder.addParameter(bindingParam);
        }
        operation.parameters().filter(p -> !TypeUtils.isIgnored((CdsAnnotatable)p)).forEach(param -> {
            TypeName paramType = this.getParameterType(entityOpt.orElse(null), operation, (CdsParameter)param);
            String cdsNameValue = eventContextClassName.simpleName() + "." + CaseFormatHelper.toUpperUnderscore(param.getName());
            ParameterSpec paramSpec = ParameterSpec.builder((TypeName)paramType, (String)NamesUtils.argumentName(param), (Modifier[])new Modifier[0]).addAnnotation(SpecWriterUtil.cdsNameAnnotation(cdsNameValue, "$L")).build();
            methodBuilder.addParameter(paramSpec);
        });
        return Optional.of(methodBuilder.build());
    }

    private TypeName getParameterType(CdsEntity boundTo, CdsOperation operation, CdsParameter param) {
        if (TypeUtils.isAnonymousType(param.getType(), this.config)) {
            ClassName innerType = NamesUtils.className(NamesUtils.eventContextClassName(this.config, boundTo, (CdsDefinition)operation), param);
            if (param.getType().isArrayed()) {
                return TypeUtils.getArrayTypeName((TypeName)innerType);
            }
            return innerType;
        }
        return TypeUtils.getAttributeType(null, param.getType(), this.config);
    }

    private static boolean isServiceDraftEnabled(CdsService service) {
        return service.entities().anyMatch(entity -> entity.findAnnotation("@odata.draft.enabled").isPresent());
    }
}

