/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.sap.cds.generator.util.CaseFormatHelper;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsName;
import com.sap.cds.ql.CdsPath;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsType;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public class SpecWriterUtil {
    private SpecWriterUtil() {
    }

    public static boolean addCdsNameAnnotation(MethodSpec.Builder builder, CdsElement attribute) {
        if (!TypeUtils.isIgnored((CdsAnnotatable)attribute)) {
            boolean addCdsNameAnnotation;
            String attributeName = SpecWriterUtil.propertyName(attribute.getName());
            boolean bl = addCdsNameAnnotation = !attributeName.equals(NamesUtils.methodName(attribute));
            if (addCdsNameAnnotation) {
                builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(NamesUtils.constantName(attribute), "$L"));
            }
            return addCdsNameAnnotation;
        }
        return false;
    }

    public static boolean addCdsPathAnnotation(MethodSpec.Builder builder, String cdsPath, String javaName) {
        boolean addCdsPathAnnotation;
        boolean bl = addCdsPathAnnotation = !cdsPath.equals(SpecWriterUtil.propertyName(javaName));
        if (addCdsPathAnnotation) {
            builder.addAnnotation(SpecWriterUtil.cdsPathAnnotation(CaseFormatHelper.toUpperUnderscore(cdsPath), "$L"));
        }
        return addCdsPathAnnotation;
    }

    public static AnnotationSpec cdsNameAnnotation(Object cdsName, String format) {
        return AnnotationSpec.builder(CdsName.class).addMember("value", format, new Object[]{cdsName}).build();
    }

    public static AnnotationSpec cdsPathAnnotation(String cdsName, String format) {
        return AnnotationSpec.builder(CdsPath.class).addMember("value", format, new Object[]{cdsName}).build();
    }

    public static void addStaticField(TypeSpec.Builder builder, CdsElement element) {
        if (!TypeUtils.isIgnored((CdsAnnotatable)element)) {
            FieldSpec staticField = FieldSpec.builder(String.class, (String)NamesUtils.constantName(element), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{element.getName()}).build();
            builder.addField(staticField);
        }
    }

    public static Optional<String> getJavaDoc(CdsAnnotatable def) {
        return def.getDoc();
    }

    public static void setJavaDoc(CdsAnnotatable attribute, MethodSpec.Builder methodBuilder) {
        SpecWriterUtil.getJavaDoc(attribute).ifPresent(a -> methodBuilder.addJavadoc(a.replace("$", "$$"), new Object[0]));
    }

    public static void addFkStaticField(TypeSpec.Builder builder, CdsElement attribute) {
        List<String> keys = SpecWriterUtil.resolveKeys(attribute).map(r -> r.path()).toList();
        if (!keys.isEmpty()) {
            keys.forEach(fk -> {
                FieldSpec field = FieldSpec.builder(String.class, (String)CaseFormatHelper.toUpperUnderscore(fk.replace(".", "_")), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{fk}).build();
                builder.addField(field);
            });
        }
    }

    private static Stream<CqnReference> resolveKeys(CdsElement assoc) {
        return SpecWriterUtil.resolveKeys((CqnReference)CQL.get((String)assoc.getName()), (CdsAssociationType)assoc.getType());
    }

    private static Stream<CqnReference> resolveKeys(CqnReference path, CdsAssociationType assoc) {
        return assoc.refs().flatMap(r -> {
            ElementRef ref = CQL.get((String)(path.path() + "." + r.path()));
            CdsType type = assoc.getTarget().getElement(r.path()).getType();
            if (type instanceof CdsAssociationType) {
                CdsAssociationType a = (CdsAssociationType)type;
                return SpecWriterUtil.resolveKeys((CqnReference)ref, a);
            }
            return Stream.of(ref);
        });
    }

    private static String propertyName(String javaName) {
        if (javaName.length() > 3 && (javaName.startsWith("set") || javaName.startsWith("get"))) {
            javaName = CaseFormatHelper.lowercaseFirst(javaName.substring(3));
        }
        return javaName;
    }
}

