/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.NameAllocator;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.CaseFormatHelper;
import com.sap.cds.generator.util.PatternMatcher;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEnumType;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsOperation;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamesUtils {
    private static final String CDS_MODEL = "CdsModel";
    private static final String UP = "up_";
    private static final String DOT = ".";
    private static final Logger logger = LoggerFactory.getLogger(NamesUtils.class);
    private static final String CONTEXT = "Context";
    private final List<Pattern> excludes;
    private final List<Pattern> includes;
    public static final String ITEM_TYPE_NAME = "Item";

    public NamesUtils(Configuration config) {
        this.excludes = config.getExcludes().stream().map(PatternMatcher::transformPattern).toList();
        this.includes = config.getIncludes().stream().map(PatternMatcher::transformPattern).toList();
    }

    public static String qualifiedWrapperBuilderName(Configuration configuration, CdsDefinition def, String classNameSuffix, boolean isWrapper) {
        boolean betterNames = configuration.getBetterNames();
        String name = (isWrapper ? CaseFormatHelper.toUpperCamel(betterNames, NamesUtils.unqualifiedContextName(def.getQualifiedName(), def.getName())) : CaseFormatHelper.toUpperCamel(betterNames, def.getName())) + classNameSuffix;
        if (def.getQualifiedName().equals(def.getName())) {
            return name;
        }
        return NamesUtils.qualifiedContextName(def.getQualifiedName(), def.getName()) + DOT + name;
    }

    public static String qualifiedContextName(String qualifiedName, String name) {
        if (name.contains(DOT)) {
            return NamesUtils.getQualifiedContextNameForDot(qualifiedName, name);
        }
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            return qualifiedName.substring(0, lastDot);
        }
        return CDS_MODEL;
    }

    static String unqualifiedContextName(String qualifiedName, String name) {
        if (name.contains(DOT)) {
            String substring = NamesUtils.getQualifiedContextNameForDot(qualifiedName, name);
            if (substring.contains(DOT)) {
                String[] bits = substring.split("\\.");
                return bits[bits.length - 1];
            }
            return substring;
        }
        if (qualifiedName.contains(DOT)) {
            String[] bits = qualifiedName.split("\\.");
            return bits[bits.length - 2];
        }
        return CDS_MODEL;
    }

    private static String getQualifiedContextNameForDot(String qualifiedName, String name) {
        String qualifiedContextName = null;
        int endIndex = qualifiedName.lastIndexOf(name) - 1;
        if (endIndex > 0) {
            qualifiedContextName = qualifiedName.substring(0, endIndex);
        }
        if (Strings.isNullOrEmpty(qualifiedContextName)) {
            return CDS_MODEL;
        }
        return qualifiedContextName;
    }

    public static String unqualifiedName(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(DOT);
        return qualifiedName.substring(lastDot + 1);
    }

    public static void warnOnJavaKeywords(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(DOT);
        if (lastDot != -1) {
            String[] split;
            for (String word : split = qualifiedName.split("\\.")) {
                if (!SourceVersion.isKeyword(word)) continue;
                logger.warn("The Entity {} contains a reserved Java keyword in its fully qualified name.", (Object)qualifiedName);
            }
        }
    }

    public static boolean isValidTechnicalEntity(Configuration configuration, CdsModel model, CdsEntity entity) {
        if (configuration.getInterfacesForAspects()) {
            if (entity.getQualifiedName().endsWith("_texts") || entity.getQualifiedName().endsWith(".texts")) {
                return true;
            }
            boolean hasUpAssociation = NamesUtils.hasUpElement(entity);
            if (hasUpAssociation) {
                String parentEntity = NamesUtils.prefix(entity.getQualifiedName());
                String association = NamesUtils.unqualifiedName(entity.getQualifiedName());
                Optional associationElement = model.findEntity(parentEntity).flatMap(e -> e.findElement(association));
                return associationElement.filter(e -> e.getType().isAssociation()).map(element -> {
                    Optional targetAspect = ((CdsAssociationType)element.getType().as(CdsAssociationType.class)).getTargetAspect();
                    return targetAspect.isPresent() && !((CdsStructuredType)targetAspect.get()).isAnonymous();
                }).orElse(false);
            }
            return true;
        }
        return !NamesUtils.hasUpElement(entity);
    }

    public static String getResolvedWrapperName(String qualifiedBuilderName, String classNameSuffix) {
        return qualifiedBuilderName.substring(0, qualifiedBuilderName.length() - 1) + "Model" + classNameSuffix;
    }

    public static String constantName(Configuration configuration, CdsDefinition definition) {
        return CaseFormatHelper.toUpperUnderscore(CaseFormatHelper.toUpperCamel(configuration.getBetterNames(), definition.getName()));
    }

    public static String packageName(CdsDefinition definition, String basePackage) {
        String packageName = NamesUtils.prefix(definition.getQualifiedName(), definition.getName());
        return NamesUtils.getPackageName(basePackage, packageName);
    }

    public static String packageName(CdsService service, String basePackage) {
        return NamesUtils.getPackageName(basePackage, service.getQualifiedName());
    }

    public static ClassName className(Configuration configuration, CdsType type) {
        return ClassName.get((String)NamesUtils.packageName((CdsDefinition)type, configuration.getBasePackage()), (String)CaseFormatHelper.toUpperCamel(configuration.getBetterNames(), NamesUtils.getJavaName((CdsAnnotatable)type, () -> ((CdsType)type).getName())), (String[])new String[0]);
    }

    public static ClassName className(Configuration configuration, ClassName parent, CdsElement element) {
        return parent.nestedClass(CaseFormatHelper.toUpperCamel(configuration.getBetterNames(), NamesUtils.getJavaName((CdsAnnotatable)element, () -> ((CdsElement)element).getName())));
    }

    public static ClassName className(Configuration configuration, ClassName parent, CdsParameter parameter) {
        return parent.nestedClass(CaseFormatHelper.toUpperCamel(configuration.getBetterNames(), parameter.getName()));
    }

    public static ClassName suffixedClassName(Configuration configuration, CdsType type) {
        return ClassName.get((String)NamesUtils.packageName((CdsDefinition)type, configuration.getBasePackage()), (String)(CaseFormatHelper.toUpperCamel(configuration.getBetterNames(), NamesUtils.getJavaName((CdsAnnotatable)type, () -> ((CdsType)type).getName())) + configuration.getClassNameSuffix()), (String[])new String[0]);
    }

    public static ClassName suffixedClassName(Configuration configuration, ClassName parent, CdsElement element) {
        return parent.nestedClass(CaseFormatHelper.toUpperCamel(configuration.getBetterNames(), NamesUtils.getJavaName((CdsAnnotatable)element, () -> ((CdsElement)element).getName())) + configuration.getClassNameSuffix());
    }

    public static ClassName typedServiceClassName(Configuration configuration, CdsService service) {
        String packageName = NamesUtils.packageName(service, configuration.getBasePackage());
        return ClassName.get((String)packageName, (String)CaseFormatHelper.toUpperCamel(configuration.getBetterNames(), NamesUtils.getJavaName((CdsAnnotatable)service, () -> ((CdsService)service).getName())), (String[])new String[0]);
    }

    public static ClassName typedServiceBuilderName(Configuration configuration, CdsService service) {
        String packageName = NamesUtils.packageName(service, configuration.getBasePackage());
        return ClassName.get((String)packageName, (String)(CaseFormatHelper.toUpperCamel(configuration.getBetterNames(), service.getName()) + configuration.getClassNameSuffix()), (String[])new String[0]);
    }

    public static ClassName templateEventHandlerClassName(Configuration configuration, CdsOperation operation) {
        String operationName = NamesUtils.getJavaName((CdsAnnotatable)operation, () -> ((CdsOperation)operation).getName());
        String handlerName = "%1$s_%2$s_handler".formatted(NamesUtils.unqualifiedName(operation.getQualifier()), operationName);
        return ClassName.get((String)configuration.getHandlerPackageName(), (String)CaseFormatHelper.toUpperCamel(configuration.getBetterNames(), handlerName), (String[])new String[0]);
    }

    public static ClassName templateEventHandlerClassName(Configuration configuration, CdsEntity entity, CdsOperation operation) {
        String operationName = NamesUtils.getJavaName((CdsAnnotatable)operation, () -> ((CdsOperation)operation).getName());
        ClassName entityClassName = NamesUtils.className(configuration, (CdsType)entity);
        String handlerName = "%1$s_%2$s_%3$s_handler".formatted(NamesUtils.unqualifiedName(entity.getQualifier()), entityClassName.simpleName(), operationName);
        return ClassName.get((String)configuration.getHandlerPackageName(), (String)CaseFormatHelper.toUpperCamel(configuration.getBetterNames(), handlerName), (String[])new String[0]);
    }

    public static String getOnHandlerMethodName(Configuration configuration, CdsOperation operation) {
        return "handle" + CaseFormatHelper.toUpperCamel(configuration.getBetterNames(), NamesUtils.getJavaName((CdsAnnotatable)operation, () -> ((CdsOperation)operation).getName()));
    }

    public static ClassName eventContextClassName(Configuration configuration, CdsEntity boundEntity, CdsDefinition def) {
        String packageName = boundEntity != null ? NamesUtils.packageName((CdsDefinition)boundEntity, configuration.getBasePackage()) : NamesUtils.packageName(def, configuration.getBasePackage());
        boolean betterName = configuration.getBetterNames();
        Optional<String> annotation = def.findAnnotation("@cds.java.this.name").or(() -> def.findAnnotation("@cds.java.name")).map(a -> (String)a.getValue());
        if (annotation.isPresent()) {
            String className = NamesUtils.contextName(betterName, annotation.get());
            return ClassName.get((String)packageName, (String)className, (String[])new String[0]);
        }
        String ownName = NamesUtils.contextName(betterName, def.getName());
        if (configuration.getUniqueEventContexts() && boundEntity != null) {
            ClassName prefix = NamesUtils.className(configuration, (CdsType)boundEntity);
            return ClassName.get((String)packageName, (String)(prefix.simpleName() + ownName), (String[])new String[0]);
        }
        return ClassName.get((String)packageName, (String)ownName, (String[])new String[0]);
    }

    private static String contextName(boolean betterName, String value) {
        return betterName ? CaseFormatHelper.toUpperCamel(true, value) + CONTEXT : CaseFormatHelper.toUpperCamel(false, value + CONTEXT);
    }

    public static String methodName(Configuration configuration, CdsElement element) {
        return CaseFormatHelper.toLowerCamel(configuration.getBetterNames(), NamesUtils.elementName((CdsAnnotatable)element, () -> ((CdsElement)element).getName()));
    }

    public static String rawName(CdsElement element) {
        return NamesUtils.elementName((CdsAnnotatable)element, () -> ((CdsElement)element).getName());
    }

    public static String methodName(Configuration configuration, CdsParameter parameter) {
        return CaseFormatHelper.toLowerCamel(configuration.getBetterNames(), NamesUtils.elementName((CdsAnnotatable)parameter, () -> ((CdsParameter)parameter).getName()));
    }

    public static String methodName(Configuration configuration, CdsOperation operation) {
        if (!configuration.getBetterNames()) {
            return NamesUtils.getJavaName((CdsAnnotatable)operation, () -> ((CdsOperation)operation).getName()).replace('.', '_');
        }
        return CaseFormatHelper.toLowerCamel(configuration.getBetterNames(), NamesUtils.getJavaName((CdsAnnotatable)operation, () -> ((CdsOperation)operation).getName()));
    }

    public static String setterName(Configuration configuration, CdsElement element) {
        return "set" + CaseFormatHelper.toUpperCamel(configuration.getBetterNames(), NamesUtils.elementName((CdsAnnotatable)element, () -> ((CdsElement)element).getName()));
    }

    public static String getterName(Configuration configuration, CdsElement element) {
        return "get" + CaseFormatHelper.toUpperCamel(configuration.getBetterNames(), NamesUtils.elementName((CdsAnnotatable)element, () -> ((CdsElement)element).getName()));
    }

    public static String setterName(Configuration configuration, CdsParameter parameter) {
        return "set" + CaseFormatHelper.toUpperCamel(configuration.getBetterNames(), NamesUtils.elementName((CdsAnnotatable)parameter, () -> ((CdsParameter)parameter).getName()));
    }

    public static String getterName(Configuration configuration, CdsParameter parameter) {
        return "get" + CaseFormatHelper.toUpperCamel(configuration.getBetterNames(), NamesUtils.elementName((CdsAnnotatable)parameter, () -> ((CdsParameter)parameter).getName()));
    }

    public static String argumentName(Configuration configuration, CdsElement element) {
        return NamesUtils.methodName(configuration, element);
    }

    public static String argumentName(Configuration configuration, CdsParameter parameter) {
        return NamesUtils.methodName(configuration, parameter);
    }

    public static String constantName(CdsElement element) {
        return CaseFormatHelper.toUpperUnderscore(NamesUtils.elementName((CdsAnnotatable)element, () -> ((CdsElement)element).getName()));
    }

    public static String normalizedConstantName(CdsEnumType.Enumeral<?> enumeral) {
        return NamesUtils.javaSafeConstantName(NamesUtils.getJavaName(enumeral, () -> enumeral.name()));
    }

    private static String elementName(CdsAnnotatable element, Supplier<String> defaultValue) {
        Optional cdsJavaName = Optional.empty();
        if (element.findAnnotation("@odata.foreignKey4").isEmpty()) {
            cdsJavaName = element.findAnnotation("@cds.java.name");
        }
        return cdsJavaName.map(CdsAnnotation::getValue).orElse(defaultValue.get());
    }

    private static String getJavaName(CdsAnnotatable definition, Supplier<String> defaultNameSupplier) {
        return definition.findAnnotation("@cds.java.this.name").or(() -> definition.findAnnotation("@cds.java.name")).map(a -> (String)a.getValue()).orElseGet(defaultNameSupplier);
    }

    private static String javaSafeConstantName(String name) {
        if (SourceVersion.isName(name)) {
            return CaseFormatHelper.toUpperUnderscore(name);
        }
        return "_" + CaseFormatHelper.toUpperUnderscore(NameAllocator.toJavaIdentifier((String)name));
    }

    public boolean isExcluded(String qualifiedName) {
        boolean included = this.includes.isEmpty() || NamesUtils.matchesAny(qualifiedName, this.includes);
        return !(included &= !NamesUtils.matchesAny(qualifiedName, this.excludes));
    }

    @VisibleForTesting
    static String prefix(String qualifiedName, String name) {
        if (qualifiedName.equals(name)) {
            return null;
        }
        return qualifiedName.substring(0, qualifiedName.lastIndexOf(name) - 1);
    }

    private static String getPackageName(String basePackage, String packageName) {
        if (!Strings.isNullOrEmpty((String)basePackage)) {
            packageName = Joiner.on((char)'.').skipNulls().join((Object)basePackage, (Object)packageName, new Object[0]);
        }
        if (Strings.isNullOrEmpty((String)packageName)) {
            packageName = "model";
        }
        return packageName.toLowerCase(Locale.US);
    }

    private static boolean matchesAny(String qualifiedName, List<Pattern> patternList) {
        return patternList.stream().anyMatch(pm -> pm.matcher(qualifiedName).matches());
    }

    private static boolean hasUpElement(CdsEntity entity) {
        return entity.elements().anyMatch(e -> e.getName().startsWith(UP) && e.getType().isAssociation() && e.isKey());
    }

    private static String prefix(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            return qualifiedName.substring(0, lastDot);
        }
        return null;
    }
}

