/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.util;

import java.util.regex.Pattern;

class PatternMatcher {
    private static final String DOT = "\\.";
    private static final String CHAR = "[^\\.]";
    private static final String CHARS = PatternMatcher.many("[^\\.]");
    private static final String PATH = CHARS + "\\.";
    private static final String PATHS = PatternMatcher.many(PATH);

    private PatternMatcher() {
    }

    static Pattern transformPattern(String pattern) {
        if (((String)pattern).endsWith("**")) {
            pattern = (String)pattern + ".*";
        }
        char[] chars = ((String)pattern).toCharArray();
        int length = ((String)pattern).length();
        StringBuilder regex = new StringBuilder();
        block4: for (int i = 0; i < length; ++i) {
            char c = chars[i];
            switch (c) {
                case '.': {
                    regex.append(DOT);
                    continue block4;
                }
                case '*': {
                    if (((String)pattern).indexOf("**.", i) == i) {
                        regex.append(PATHS);
                        i += 2;
                        continue block4;
                    }
                    regex.append(CHARS);
                    continue block4;
                }
                default: {
                    regex.append(c);
                }
            }
        }
        regex.append("$");
        return Pattern.compile(regex.toString());
    }

    private static String many(String pattern) {
        return "(" + pattern + ")*";
    }
}

