/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.palantir.javapoet.AnnotationSpec;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.CodeBlock;
import com.palantir.javapoet.FieldSpec;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeName;
import com.palantir.javapoet.TypeSpec;
import com.palantir.javapoet.WildcardTypeName;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.MethodStyle;
import com.sap.cds.generator.util.CaseFormatHelper;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.writer.CreateConsumptionInterfaceVisitor;
import com.sap.cds.generator.writer.ModelWriter;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.generator.writer.Types;
import com.sap.cds.ql.CdsName;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsOperation;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.util.CdsModelUtils;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public class CreateEventContextInterfaceVisitor
implements CdsVisitor {
    private static final ParameterizedTypeName MAP_STR2OBJ = ParameterizedTypeName.get((ClassName)Types.MAP, (TypeName[])new TypeName[]{Types.STRING, WildcardTypeName.subtypeOf(Object.class)});
    private static final String PROXYMETHOD_ARG_NAME = "entityName";
    private final TypeSpec.Builder builder;
    private final Configuration cfg;
    private final boolean bounded;
    private final String boundEntityName;
    private final ModelWriter.Context context;
    private final ClassName className;

    CreateEventContextInterfaceVisitor(TypeSpec.Builder builder, ClassName className, String boundEntityName, ModelWriter.Context context) {
        this.builder = builder;
        this.className = className;
        this.cfg = context.config();
        this.boundEntityName = boundEntityName;
        this.builder.addSuperinterface((TypeName)Types.EVENT_CONTEXT);
        this.bounded = boundEntityName != null;
        this.context = context;
    }

    public void visit(CdsAction action) {
        this.addGetCqnMethod();
        this.addSetCqnMethod();
        this.addStaticQualifiedAttribute((CdsDefinition)action);
        this.prepareDefinition((CdsOperation)action);
    }

    public void visit(CdsFunction function) {
        this.addGetCqnMethod();
        this.addSetCqnMethod();
        this.addStaticQualifiedAttribute((CdsDefinition)function);
        this.prepareDefinition((CdsOperation)function);
    }

    public void visit(CdsEvent event) {
        ClassName eventClassName = NamesUtils.className(this.cfg, (CdsType)event);
        this.addGetter(eventClassName);
        this.addSetter(eventClassName);
        this.addStaticQualifiedAttribute((CdsDefinition)event);
        this.addStaticProxyMethod();
        this.builder.addAnnotation(CreateEventContextInterfaceVisitor.eventNameAnnotation(event.getName(), "$S"));
    }

    private void addGetter(ClassName event) {
        String methodName = this.cfg.getMethodStyle() == MethodStyle.BEAN ? "getData" : "data";
        MethodSpec.Builder resultGetterBuilder = MethodSpec.methodBuilder((String)methodName).returns((TypeName)event).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        this.builder.addMethod(resultGetterBuilder.build());
    }

    private void addSetter(ClassName event) {
        String methodName;
        TypeName returnType = TypeName.VOID;
        if (this.cfg.getMethodStyle() == MethodStyle.BEAN) {
            methodName = "setData";
        } else {
            methodName = "data";
            returnType = this.className;
        }
        MethodSpec.Builder resultGetterBuilder = MethodSpec.methodBuilder((String)methodName).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)event, "event", new Modifier[0]);
        this.builder.addMethod(resultGetterBuilder.build());
    }

    private void addGetCqnMethod() {
        if (this.bounded) {
            String methodName = this.cfg.getMethodStyle() == MethodStyle.BEAN ? "getCqn" : "cqn";
            MethodSpec.Builder resultGetterBuilder = MethodSpec.methodBuilder((String)methodName).returns((TypeName)Types.CQN_SELECT).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            this.builder.addMethod(resultGetterBuilder.build());
        }
    }

    private void addSetCqnMethod() {
        if (this.bounded) {
            TypeName returnType;
            String methodName = "cqn";
            if (this.cfg.getMethodStyle() == MethodStyle.BEAN) {
                returnType = TypeName.VOID;
                methodName = "setCqn";
            } else {
                returnType = this.className;
            }
            MethodSpec.Builder resultGetterBuilder = MethodSpec.methodBuilder((String)methodName).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)Types.CQN_SELECT, "select", new Modifier[0]);
            this.builder.addMethod(resultGetterBuilder.build());
        }
    }

    private void addStaticQualifiedAttribute(CdsDefinition def) {
        String name = def.getName();
        FieldSpec staticField = FieldSpec.builder(String.class, (String)"CDS_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{name}).build();
        this.builder.addField(staticField);
    }

    private void prepareDefinition(CdsOperation operation) {
        if (this.bounded) {
            this.addStaticProxyMethodBound();
        }
        this.addResultMethod(operation);
        this.addStaticProxyMethod();
        this.builder.addAnnotation(CreateEventContextInterfaceVisitor.eventNameAnnotation(operation.getName(), "$S"));
    }

    private void addResultMethod(CdsOperation operation) {
        String getter;
        String setter;
        TypeName setReturnType;
        TypeName resultType = null;
        Optional opt = operation.returnType();
        if (opt.isEmpty()) {
            return;
        }
        CdsType returnType = (CdsType)opt.get();
        resultType = TypeUtils.isAnonymousType(returnType, this.cfg) ? this.generateInnerInterface(this.className, returnType, null) : TypeUtils.getAttributeType(this.className, returnType, this.cfg);
        if (resultType == null && (resultType = TypeUtils.getOperationResultType(null, operation, returnType, this.cfg)) == null) {
            return;
        }
        if (this.cfg.getMethodStyle() == MethodStyle.BEAN) {
            setReturnType = TypeName.VOID;
            setter = "setResult";
            getter = "getResult";
        } else {
            setReturnType = this.className;
            getter = "result";
            setter = "result";
        }
        MethodSpec.Builder resultSetterBuilder = MethodSpec.methodBuilder((String)setter).returns(setReturnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(resultType, "result", new Modifier[0]);
        MethodSpec.Builder resultGetterBuilder = MethodSpec.methodBuilder((String)getter).returns(resultType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        this.builder.addMethod(resultSetterBuilder.build());
        this.builder.addMethod(resultGetterBuilder.build());
    }

    private TypeName generateInnerInterface(ClassName parent, CdsType returnType, CdsParameter parameter) {
        Stream elements;
        ClassName innerInterfaceName;
        ClassName resultType = innerInterfaceName = parameter == null ? parent.nestedClass("ReturnType") : NamesUtils.className(this.cfg, parent, parameter);
        TypeSpec.Builder innerInterfaceBuilder = TypeSpec.interfaceBuilder((ClassName)innerInterfaceName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addSuperinterface((TypeName)Types.CDS_DATA);
        if (returnType.isStructured()) {
            elements = ((CdsStructuredType)returnType.as(CdsStructuredType.class)).elements();
        } else {
            resultType = TypeUtils.getArrayTypeName((TypeName)resultType);
            elements = ((CdsStructuredType)((CdsArrayedType)returnType.as(CdsArrayedType.class)).getItemsType().as(CdsStructuredType.class)).elements();
        }
        elements.forEach(e -> e.accept((CdsVisitor)new CreateConsumptionInterfaceVisitor(innerInterfaceBuilder, innerInterfaceName, this.context, Set.of())));
        TypeUtils.addStaticFactoryMethods(this.builder, (TypeName)innerInterfaceName, innerInterfaceBuilder);
        this.builder.addType(innerInterfaceBuilder.build());
        return resultType;
    }

    private void addStaticProxyMethod() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"create").returns((TypeName)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        if (this.bounded) {
            methodBuilder.addParameter(TypeName.get(String.class), PROXYMETHOD_ARG_NAME, new Modifier[0]);
        }
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        codeBuilder.addStatement("return EventContext.create($T.class, $N)", new Object[]{this.className, this.bounded ? PROXYMETHOD_ARG_NAME : "null"});
        methodBuilder.addCode(codeBuilder.build());
        this.builder.addMethod(methodBuilder.build());
    }

    private void addStaticProxyMethodBound() {
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"create").returns((TypeName)this.className).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        CodeBlock.Builder codeBuilder = CodeBlock.builder();
        codeBuilder.addStatement("return EventContext.create($T.class, $S)", new Object[]{this.className, this.boundEntityName});
        methodBuilder.addCode(codeBuilder.build());
        this.builder.addMethod(methodBuilder.build());
    }

    private static AnnotationSpec eventNameAnnotation(String cdsName, String format) {
        return AnnotationSpec.builder((ClassName)Types.EVENT_NAME).addMember("value", format, new Object[]{cdsName}).build();
    }

    public void visit(CdsParameter parameter) {
        this.addStaticAttribute(parameter);
        CdsType returnType = parameter.getType();
        if (TypeUtils.isAnonymousType(returnType, this.cfg)) {
            TypeName resultType = this.generateInnerInterface(this.className, returnType, parameter);
            this.addGetterMethod(parameter, resultType);
            this.addSetterMethod(parameter, resultType);
        } else {
            this.addParamGetter(parameter);
            this.addParamSetter(parameter);
        }
    }

    private void addParamGetter(CdsParameter parameter) {
        TypeName returnType = TypeUtils.getAttributeType(this.className, parameter.getType(), this.cfg);
        this.addGetterMethod(parameter, returnType);
    }

    private void addGetterMethod(CdsParameter parameter, TypeName returnType) {
        if (returnType == null || TypeUtils.isIgnored((CdsAnnotatable)parameter)) {
            return;
        }
        String getter = this.cfg.getMethodStyle().equals((Object)MethodStyle.BEAN) ? NamesUtils.getterName(this.cfg, parameter) : NamesUtils.methodName(this.cfg, parameter);
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)getter).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
        this.addJavaDoc(parameter, methodBuilder);
        CreateEventContextInterfaceVisitor.addCdsNameAnnotation(methodBuilder, parameter.getName(), getter);
        this.builder.addMethod(methodBuilder.build());
    }

    private void addParamSetter(CdsParameter parameter) {
        TypeName paramType = this.getSetterParam(parameter.getType());
        this.addSetterMethod(parameter, paramType);
    }

    private void addSetterMethod(CdsParameter parameter, TypeName paramType) {
        String setter;
        TypeName returnType;
        if (paramType == null || TypeUtils.isIgnored((CdsAnnotatable)parameter)) {
            return;
        }
        if (this.cfg.getMethodStyle() == MethodStyle.BEAN) {
            returnType = TypeName.VOID;
            setter = NamesUtils.setterName(this.cfg, parameter);
        } else {
            returnType = this.className;
            setter = NamesUtils.methodName(this.cfg, parameter);
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)setter).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(paramType, NamesUtils.methodName(this.cfg, parameter), new Modifier[0]);
        this.addJavaDoc(parameter, methodBuilder);
        CreateEventContextInterfaceVisitor.addCdsNameAnnotation(methodBuilder, parameter.getName(), setter);
        this.builder.addMethod(methodBuilder.build());
    }

    private TypeName getSetterParam(CdsType type) {
        if (type.isAssociation()) {
            if (CdsModelUtils.isSingleValued((CdsType)type)) {
                return MAP_STR2OBJ;
            }
            return TypeUtils.listOf((TypeName)WildcardTypeName.subtypeOf((TypeName)MAP_STR2OBJ));
        }
        return TypeUtils.getAttributeType(this.className, type, this.cfg);
    }

    private static AnnotationSpec cdsNameAnnotation(String cdsName, String format) {
        return AnnotationSpec.builder(CdsName.class).addMember("value", format, new Object[]{cdsName}).build();
    }

    private static MethodSpec.Builder addCdsNameAnnotation(MethodSpec.Builder builder, String cdsName, String javaName) {
        if (!cdsName.equals(CreateEventContextInterfaceVisitor.propertyName(javaName))) {
            builder.addAnnotation(CreateEventContextInterfaceVisitor.cdsNameAnnotation(CaseFormatHelper.toUpperUnderscore(cdsName), "$L"));
        }
        return builder;
    }

    private static String propertyName(String javaName) {
        if (javaName.startsWith("set") || javaName.startsWith("get")) {
            javaName = CaseFormatHelper.lowercaseFirst(javaName.substring(3));
        }
        return javaName;
    }

    private void addStaticAttribute(CdsParameter parameter) {
        String name = CaseFormatHelper.toUpperUnderscore(parameter.getName());
        FieldSpec staticField = FieldSpec.builder(String.class, (String)name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{parameter.getName()}).build();
        this.builder.addField(staticField);
    }

    private void addJavaDoc(CdsParameter param, MethodSpec.Builder methodBuilder) {
        if (this.cfg.getDocs()) {
            SpecWriterUtil.setJavaDoc((CdsAnnotatable)param, methodBuilder);
        }
    }
}

