/************************************************************************
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.generator;

import static com.sap.cds.generator.util.GeneratedFile.Consumer;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.generator.Result.Status;
import com.sap.cds.generator.writer.CreateTemplateHandlerClassVisitor;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollector;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollectorFactory;

public class Cds4jOperationGenerator {
	private static final Logger logger = LoggerFactory.getLogger(Cds4jOperationGenerator.class);
	private static final IssueCollector issueCollector = IssueCollectorFactory
			.getIssueCollector(Cds4jOperationGenerator.class);
	private final Configuration configuration;

	public Cds4jOperationGenerator(Configuration configuration) {
		this.configuration = configuration;
	}

	public Result generate(CsnSupplier csn, Consumer consumer) {
		Cds4jCodegenRunner helper = new Cds4jCodegenRunner(logger, issueCollector);
		return helper.generate(csn, model -> {
			if (Cds4jCodegenRunner.noRelevantIssues(configuration.getParserMode(), configuration.getGeneratorMode())) {
				model.accept(new CreateTemplateHandlerClassVisitor(configuration, model, consumer));
				return Status.SUCCESS;
			}
			return Status.FAILURE;
		});
	}
}
