/************************************************************************
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.generator;

import java.util.List;

import com.sap.cds.generator.util.GeneratorMode;
import com.sap.cds.generator.util.ParserMode;

public interface Configuration {

	ParserMode getParserMode();

	GeneratorMode getGeneratorMode();

	MethodStyle getMethodStyle();

	String getBasePackage();

	boolean getEventContext();

	List<String> getExcludes();

	List<String> getIncludes();

	String getClassNameSuffix();

	boolean getDocs();

	boolean fkAccessors();

	String getPluginInformation();

	GeneratedAnnotationDetailLevel getGenerationAnnotationDetailLevel();

	boolean getSharedInterfaces();

	boolean getCqnServices();

	boolean getUniqueEventContexts();

	boolean getInterfacesForAspects();

	String getHandlerPackageName();

	boolean getStrictSetters();

	boolean getBetterNames();

	boolean getGroupOptionalOperationParameters();

	void setGroupOptionalOperationParameters(boolean groupOptionalOperationParameters);

	Configuration clone();
}
