/************************************************************************
 * © 2022-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.generator.util;

import java.time.Instant;

import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.GeneratedAnnotationDetailLevel;
import com.sap.cds.generator.writer.Types;
import com.palantir.javapoet.AnnotationSpec;
import com.palantir.javapoet.TypeSpec.Builder;

public class GeneratedAnnotationUtil {

	private final Configuration cfg;
	private final AnnotationSpec annotation;

	public GeneratedAnnotationUtil(Configuration cfg) {
		this.cfg = cfg;
		AnnotationSpec.Builder builder = AnnotationSpec.builder(Types.GENERATED);
		builder.addMember("value", "$S", "cds-maven-plugin");

		if (cfg.getGenerationAnnotationDetailLevel() == GeneratedAnnotationDetailLevel.FULL) {
			builder.addMember("date", "$S", Instant.now().toString())
				.addMember("comments", "$S", cfg.getPluginInformation());
		}

		annotation = builder.build();
	}

	public void addTo(Builder builder) {
		if (cfg.getGenerationAnnotationDetailLevel() != GeneratedAnnotationDetailLevel.NONE) {
			builder.addAnnotation(annotation);
		}
	}
}
