/************************************************************************
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.generator.util;

import java.io.IOException;
import java.io.InputStream;

public interface GeneratedFile extends FileLocation {
	InputStream getContent() throws IOException;

	@FunctionalInterface
	interface Consumer {
		void accept(GeneratedFile file) throws IOException;
	}

	@FunctionalInterface
	interface Supplier {
		GeneratedFile get(FileLocation location) throws IOException;
	}

	interface Accessor extends Consumer, Supplier {
	}
}
