/************************************************************************
 * © 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.generator.writer;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

import javax.annotation.processing.Generated;

import com.sap.cds.CdsData;
import com.sap.cds.Struct;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.palantir.javapoet.ClassName;

public class Types {

	private Types() {
	}

	private static final String CDS_SERVICES_PACKAGE = "com.sap.cds.services";
	private static final String CDS_PACKAGE = CDS_SERVICES_PACKAGE + ".cds";

	// CDS4J & cds-services classes
	public static final ClassName STRUCTURED_TYPE = ClassName.get(StructuredType.class);
	public static final ClassName PREDICATE = ClassName.get(CqnPredicate.class);
	public static final ClassName REFERENCE = ClassName.get(ElementRef.class);
	public static final ClassName STRUCT = ClassName.get(Struct.class);
	public static final ClassName CDS_DATA = ClassName.get(CdsData.class);
	public static final ClassName EVENT_CONTEXT = ClassName.get(CDS_SERVICES_PACKAGE, "EventContext");
	public static final ClassName EVENT_NAME = ClassName.get(CDS_SERVICES_PACKAGE, "EventName");
	public static final ClassName CQN_SELECT = ClassName.get(CqnSelect.class);
	public static final ClassName DRAFT_SERVICE = ClassName.get("com.sap.cds.services.draft", "DraftService");
	public static final ClassName APPLICATION_SERVICE = ClassName.get(CDS_PACKAGE, "ApplicationService");
	public static final ClassName REMOTE_SERVICE = ClassName.get(CDS_PACKAGE, "RemoteService");
	public static final ClassName CQN_SERVICE = ClassName.get(CDS_PACKAGE, "CqnService");
	public static final String RETURN_TYPE = "ReturnType";
	public static final String RESULT_ARGUMENT = "result";
	public static final ClassName EVENT_HANDLER = ClassName.get("com.sap.cds.services.handler", "EventHandler");
	public static final ClassName SERVICE_NAME = ClassName.get("com.sap.cds.services.handler.annotations", "ServiceName");
	public static final ClassName HANDLER_ON = ClassName.get("com.sap.cds.services.handler.annotations", "On");

	// JDK classes
	public static final ClassName FUNCTION = ClassName.get(Function.class);
	public static final ClassName COLLECTION = ClassName.get(Collection.class);
	public static final ClassName LIST = ClassName.get(List.class);
	public static final ClassName MAP = ClassName.get(Map.class);
	public static final ClassName HASH_MAP = ClassName.get(HashMap.class);
	public static final ClassName CLASS = ClassName.get(Class.class);
	public static final ClassName STRING = ClassName.get(String.class);
	public static final ClassName OBJECT = ClassName.get(Object.class);
	public static final ClassName GENERATED = ClassName.get(Generated.class);

	// Spring Boot annotations
	public static final ClassName SPRING_BOOT_COMPONENT = ClassName.get("org.springframework.stereotype", "Component");

	// Some conventional constants
	public static final String DOT_CDS_NAME = ".CDS_NAME";
}
