/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.util;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.google.common.base.CaseFormat;
import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.util.stream.Collectors;

public class CaseFormatHelper {
    private CaseFormatHelper() {
    }

    public static String lowercaseFirst(String s) {
        char[] c = s.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    static String toUpperCamel(boolean betterNames, String name) {
        if (betterNames) {
            return Splitter.on((CharMatcher)CharMatcher.anyOf((CharSequence)"_./")).omitEmptyStrings().splitToStream((CharSequence)name).map(word -> {
                if (CaseFormatHelper.isUppercaseOnly(word)) {
                    return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, word);
                }
                return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, word);
            }).collect(Collectors.joining());
        }
        return CaseFormatHelper.convert(name.replace(".", "_"), CaseFormat.LOWER_CAMEL, CaseFormat.UPPER_CAMEL);
    }

    static String toLowerCamel(boolean betterNames, String name) {
        if (betterNames) {
            return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, CaseFormatHelper.toUpperCamel(true, name));
        }
        return CaseFormatHelper.convert(name, CaseFormat.UPPER_CAMEL, CaseFormat.LOWER_CAMEL);
    }

    public static String toUpperUnderscore(String name) {
        if (CaseFormatHelper.isUppercaseOnly(name)) {
            return name;
        }
        return new PropertyNamingStrategies.UpperSnakeCaseStrategy().translate(name).replaceAll("_+", "_");
    }

    private static String convert(String name, CaseFormat sourceFormat, CaseFormat targetFormat) {
        if (CaseFormatHelper.isUppercaseOnly(name)) {
            return CaseFormat.UPPER_UNDERSCORE.to(targetFormat, name);
        }
        if (!name.contains("_")) {
            return sourceFormat.to(targetFormat, name);
        }
        String[] parts = name.split("_");
        StringBuilder lowerCamel = new StringBuilder(sourceFormat.to(targetFormat, parts[0]));
        for (int i = 1; i < parts.length; ++i) {
            lowerCamel.append(CaseFormatHelper.toUpperCamel(false, parts[i]));
        }
        return lowerCamel.toString();
    }

    public static boolean isUppercaseOnly(String name) {
        return name.chars().noneMatch(Character::isLowerCase);
    }
}

