/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator;

import com.sap.cds.generator.Cds4jCodegenRunner;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.CsnSupplier;
import com.sap.cds.generator.Result;
import com.sap.cds.generator.util.GeneratedFile;
import com.sap.cds.generator.writer.CreateTemplateHandlerClassVisitor;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollector;
import com.sap.cds.reflect.impl.reader.issuecollector.IssueCollectorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cds4jOperationGenerator {
    private static final Logger logger = LoggerFactory.getLogger(Cds4jOperationGenerator.class);
    private static final IssueCollector issueCollector = IssueCollectorFactory.getIssueCollector(Cds4jOperationGenerator.class);
    private final Configuration configuration;

    public Cds4jOperationGenerator(Configuration configuration) {
        this.configuration = configuration;
    }

    public Result generate(CsnSupplier csn, GeneratedFile.Consumer consumer) {
        Cds4jCodegenRunner helper = new Cds4jCodegenRunner(logger, issueCollector);
        return helper.generate(csn, (CdsModel model) -> {
            if (Cds4jCodegenRunner.noRelevantIssues(this.configuration.getParserMode(), this.configuration.getGeneratorMode())) {
                model.accept((CdsVisitor)new CreateTemplateHandlerClassVisitor(this.configuration, model, consumer));
                return Result.Status.SUCCESS;
            }
            return Result.Status.FAILURE;
        });
    }
}

