/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.util;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.google.common.base.CaseFormat;
import java.util.regex.Pattern;

public class CaseFormatHelper {
    private static final Pattern IDENTIFIER_WHITESPACE = Pattern.compile("[\\s\\.\\$\\_\\/]");
    private static final Pattern PATH_WHITESPACE = Pattern.compile("[\\s\\$\\_\\/]");

    private CaseFormatHelper() {
    }

    public static String lowercaseFirst(String s) {
        char[] c = s.toCharArray();
        c[0] = Character.toLowerCase(c[0]);
        return new String(c);
    }

    static String normalizeWhitespaceInIdentifier(String from) {
        return IDENTIFIER_WHITESPACE.matcher(from).replaceAll("_");
    }

    static String normalizeWhiteSpaceInPath(String from) {
        return PATH_WHITESPACE.matcher(from).replaceAll("_");
    }

    static String toUpperCamel(String name) {
        return CaseFormatHelper.convert(name.replace(".", "_"), CaseFormat.LOWER_CAMEL, CaseFormat.UPPER_CAMEL);
    }

    static String toLowerCamel(String name) {
        return CaseFormatHelper.convert(name, CaseFormat.UPPER_CAMEL, CaseFormat.LOWER_CAMEL);
    }

    static String toUpperUnderscore(String name) {
        if (CaseFormatHelper.isUppercaseOnly(name)) {
            return name;
        }
        return new PropertyNamingStrategies.UpperSnakeCaseStrategy().translate(name).replaceAll("_+", "_");
    }

    private static String convert(String name, CaseFormat sourceFormat, CaseFormat targetFormat) {
        if (CaseFormatHelper.isUppercaseOnly(name)) {
            return CaseFormat.UPPER_UNDERSCORE.to(targetFormat, name);
        }
        if (!name.contains("_")) {
            return sourceFormat.to(targetFormat, name);
        }
        String[] parts = name.split("_");
        StringBuilder lowerCamel = new StringBuilder(sourceFormat.to(targetFormat, parts[0]));
        for (int i = 1; i < parts.length; ++i) {
            lowerCamel.append(CaseFormatHelper.toUpperCamel(parts[i]));
        }
        return lowerCamel.toString();
    }

    static boolean isUppercaseOnly(String name) {
        return name.chars().noneMatch(Character::isLowerCase);
    }
}

