/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.ParameterSpec;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeName;
import com.palantir.javapoet.TypeSpec;
import com.palantir.javapoet.WildcardTypeName;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.MethodStyle;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.writer.ModelWriter;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.generator.writer.Types;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.CdsEventBuilder;
import com.sap.cds.util.CdsModelUtils;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public class CreateConsumptionInterfaceVisitor
implements CdsVisitor {
    private static final ParameterizedTypeName MAP_STR2OBJ = ParameterizedTypeName.get((ClassName)Types.MAP, (TypeName[])new TypeName[]{Types.STRING, WildcardTypeName.subtypeOf(Object.class)});
    private final TypeSpec.Builder builder;
    private final Configuration cfg;
    private final ClassName className;
    private final ModelWriter.Context context;
    private final Set<String> parentElements;

    CreateConsumptionInterfaceVisitor(TypeSpec.Builder builder, ClassName className, ModelWriter.Context context, Collection<CdsStructuredType> parents) {
        this.builder = builder;
        this.cfg = context.config();
        this.className = className;
        this.context = context;
        this.parentElements = parents.stream().flatMap(t -> t.elements().filter(CreateConsumptionInterfaceVisitor::isAnonymousType).map(CdsElementDefinition::getName)).collect(Collectors.toSet());
    }

    public void visit(CdsEntity entity) {
        this.builder.addSuperinterface((TypeName)Types.CDS_DATA);
        ClassName javaName = NamesUtils.className(this.cfg, (CdsType)entity);
        this.addRefMethod(entity);
        TypeUtils.addStaticFactoryMethods(this.builder, (TypeName)javaName, new TypeSpec.Builder[0]);
        LinkedHashMap<String, ParameterSpec> keyElements = new LinkedHashMap<String, ParameterSpec>();
        entity.keyElements().filter(k -> !TypeUtils.isIgnored((CdsAnnotatable)k)).forEach(key -> keyElements.put(NamesUtils.constantName(this.context.config(), key), ParameterSpec.builder((TypeName)this.getSetterParam((CdsElement)key), (String)NamesUtils.argumentName(this.cfg, key), (Modifier[])new Modifier[0]).build()));
        if (keyElements.size() == 1) {
            TypeUtils.addStaticCreateForKeys(this.builder, javaName, keyElements);
        }
        this.builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(entity.getQualifiedName(), "$S"));
    }

    public void visit(CdsEvent event) {
        this.builder.addSuperinterface((TypeName)Types.CDS_DATA);
        TypeUtils.addStaticFactoryMethods(this.builder, (TypeName)this.className, new TypeSpec.Builder[0]);
        this.builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(event.getQualifiedName(), "$S"));
    }

    public void visit(CdsStructuredType struct) {
        this.builder.addSuperinterface((TypeName)Types.CDS_DATA);
        TypeUtils.addStaticFactoryMethods(this.builder, (TypeName)NamesUtils.className(this.cfg, (CdsType)struct), new TypeSpec.Builder[0]);
        this.builder.addAnnotation(SpecWriterUtil.cdsNameAnnotation(struct.getQualifiedName(), "$S"));
    }

    public void visit(CdsArrayedType type) {
        if (!type.getQualifiedName().isEmpty() && type.getItemsType().isStructured() && type.getItemsType().getQualifiedName().isEmpty() && !type.getItemsType().isSimple()) {
            ClassName itemsInterfaceName = this.className.nestedClass("Item");
            TypeSpec.Builder innerInterfaceBuilder = TypeSpec.interfaceBuilder((ClassName)itemsInterfaceName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addSuperinterface((TypeName)Types.CDS_DATA);
            ((CdsStructuredType)type.getItemsType().as(CdsStructuredType.class)).elements().forEach(e -> e.accept((CdsVisitor)new CreateConsumptionInterfaceVisitor(innerInterfaceBuilder, this.className.nestedClass("Item"), this.context, Set.of())));
            TypeUtils.addStaticFactoryMethods(this.builder, (TypeName)itemsInterfaceName, innerInterfaceBuilder);
            this.builder.addType(innerInterfaceBuilder.build());
        }
    }

    public void visit(CdsElement element) {
        if (this.context.isTenantDiscriminator(element) || TypeUtils.isIgnored((CdsAnnotatable)element)) {
            return;
        }
        SpecWriterUtil.addStaticField(this.context.config(), this.builder, element);
        if (CreateConsumptionInterfaceVisitor.isAnonymousType(element) && !this.parentElements.contains(element.getName())) {
            ClassName elementName = NamesUtils.className(this.cfg, this.className, element);
            TypeName returnType = TypeUtils.getReturnType(this.className, element, this.cfg);
            TypeSpec.Builder innerInterfaceBuilder = TypeSpec.interfaceBuilder((ClassName)elementName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
            innerInterfaceBuilder.addSuperinterface((TypeName)Types.CDS_DATA);
            CdsType type = element.getType();
            Stream elements = type.isStructured() && type.getQualifiedName().isEmpty() ? ((CdsStructuredType)type.as(CdsStructuredType.class)).elements() : (type.isArrayed() ? ((CdsStructuredType)((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType().as(CdsStructuredType.class)).elements() : TypeUtils.getAnonymousElements(element));
            elements.forEach(e -> e.accept((CdsVisitor)new CreateConsumptionInterfaceVisitor(innerInterfaceBuilder, elementName, this.context, Set.of())));
            TypeUtils.addStaticFactoryMethods(this.builder, (TypeName)elementName, innerInterfaceBuilder);
            this.populateGetter(element, returnType, false);
            this.populateSetter(element, returnType, false);
            this.builder.addType(innerInterfaceBuilder.build());
        } else {
            this.getter(element);
            this.setter(element);
        }
        if (this.cfg.fkAccessors() && CdsModelUtils.managedToOne((CdsType)element.getType()) && !element.getName().equals("DraftAdministrativeData")) {
            SpecWriterUtil.addFkStaticField(this.context.config(), this.builder, element);
            this.addFkMethods(element);
        }
    }

    private void addRefMethod(CdsEntity entity) {
        if (!entity.isAbstract()) {
            ClassName returnType = NamesUtils.suffixedClassName(this.context.config(), (CdsType)entity);
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)"ref").returns((TypeName)returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            this.builder.addMethod(methodBuilder.build());
        }
    }

    private void setter(CdsElement attribute) {
        TypeName paramType = this.getSetterParam(attribute);
        if (paramType == null) {
            return;
        }
        this.populateSetter(attribute, paramType, false);
    }

    private void populateSetter(CdsElement attribute, TypeName paramType, boolean cdsPath) {
        if (!TypeUtils.isIgnored((CdsAnnotatable)attribute)) {
            String setter;
            TypeName returnType;
            if (this.cfg.getMethodStyle() == MethodStyle.BEAN) {
                returnType = TypeName.VOID;
                setter = NamesUtils.setterName(this.cfg, attribute);
            } else {
                returnType = this.className;
                setter = NamesUtils.methodName(this.cfg, attribute);
            }
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)setter).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(paramType, NamesUtils.argumentName(this.cfg, attribute), new Modifier[0]);
            this.addJavaDoc(attribute, methodBuilder);
            if (cdsPath) {
                SpecWriterUtil.addCdsPathAnnotation(this.cfg, methodBuilder, NamesUtils.constantName(this.context.config(), attribute), setter);
            } else {
                SpecWriterUtil.addCdsNameAnnotation(this.cfg, methodBuilder, attribute);
            }
            this.builder.addMethod(methodBuilder.build());
        }
    }

    private TypeName getSetterParam(CdsElement element) {
        if (!this.cfg.getStrictSetters() && element.getType().isAssociation()) {
            if (CdsModelUtils.isSingleValued((CdsType)element.getType())) {
                return MAP_STR2OBJ;
            }
            return TypeUtils.listOf((TypeName)WildcardTypeName.subtypeOf((TypeName)MAP_STR2OBJ));
        }
        return TypeUtils.getReturnType(this.className, element, this.cfg);
    }

    private void getter(CdsElement attribute) {
        TypeName returnType = TypeUtils.getReturnType(this.className, attribute, this.cfg);
        if (returnType == null) {
            return;
        }
        this.populateGetter(attribute, returnType, false);
    }

    private void populateGetter(CdsElement attribute, TypeName returnType, boolean cdsPath) {
        if (!TypeUtils.isIgnored((CdsAnnotatable)attribute)) {
            String getter = this.cfg.getMethodStyle().equals((Object)MethodStyle.BEAN) ? NamesUtils.getterName(this.cfg, attribute) : NamesUtils.methodName(this.cfg, attribute);
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)getter).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT});
            this.addJavaDoc(attribute, methodBuilder);
            if (cdsPath) {
                SpecWriterUtil.addCdsPathAnnotation(this.cfg, methodBuilder, attribute.getName(), getter);
            } else {
                SpecWriterUtil.addCdsNameAnnotation(this.cfg, methodBuilder, attribute);
            }
            this.builder.addMethod(methodBuilder.build());
        }
    }

    private void addJavaDoc(CdsElement attribute, MethodSpec.Builder methodBuilder) {
        if (!(attribute.getDeclaringType() instanceof CdsEventBuilder.EventProxy) && this.cfg.getDocs()) {
            SpecWriterUtil.setJavaDoc((CdsAnnotatable)attribute, methodBuilder);
        }
    }

    private void addFkMethods(CdsElement attribute) {
        TypeUtils.getManagedToOneFks(attribute).forEach(fkElement -> {
            if (this.context.isTenantDiscriminator((CdsElement)fkElement)) {
                return;
            }
            TypeName keyReturnType = TypeUtils.getReturnType(this.className, fkElement, this.cfg);
            if (keyReturnType == null) {
                return;
            }
            this.populateSetter((CdsElement)fkElement, keyReturnType, true);
            this.populateGetter((CdsElement)fkElement, keyReturnType, true);
        });
    }

    private static boolean isAnonymousType(CdsElement element) {
        CdsType type = element.getType();
        if (type.isArrayed()) {
            if (type.getQualifiedName().startsWith(element.getDeclaringType().getQualifiedName())) {
                CdsType itemsType = ((CdsArrayedType)type.as(CdsArrayedType.class)).getItemsType();
                return itemsType.isStructured() && itemsType.getQualifiedName().isEmpty();
            }
            return false;
        }
        if (type.isStructured() && type.getQualifiedName().isEmpty()) {
            return true;
        }
        return TypeUtils.isAnonymousAspect(element);
    }
}

