/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.palantir.javapoet.AnnotationSpec;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.ParameterSpec;
import com.palantir.javapoet.TypeName;
import com.palantir.javapoet.TypeSpec;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.GeneratedFile;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.writer.Types;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsOperation;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.reader.model.CdsConstants;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public class CreateTemplateHandlerClassVisitor
implements CdsVisitor {
    private final Configuration configuration;
    private final GeneratedFile.Consumer consumer;
    private final NamesUtils namesUtils;
    private final CdsModel model;

    public CreateTemplateHandlerClassVisitor(Configuration configuration, CdsModel model, GeneratedFile.Consumer consumer) {
        this.configuration = configuration;
        this.consumer = consumer;
        this.namesUtils = new NamesUtils(configuration);
        this.model = model;
    }

    public void visit(CdsEntity entity) {
        if (!TypeUtils.isIgnored((CdsAnnotatable)entity)) {
            Stream.concat(entity.functions(), entity.actions()).filter(o -> !CdsConstants.DRAFT_ACTIONS.contains(o.getName())).filter(o -> !TypeUtils.isIgnored((CdsAnnotatable)o) && !this.namesUtils.isExcluded(String.join((CharSequence)".", entity.getQualifiedName(), o.getQualifiedName()))).forEach(o -> this.generate(entity, (CdsOperation)o));
        }
    }

    public void visit(CdsAction action) {
        if (this.isRelevant((CdsDefinition)action)) {
            this.generate((CdsOperation)action);
        }
    }

    public void visit(CdsFunction function) {
        if (this.isRelevant((CdsDefinition)function)) {
            this.generate((CdsOperation)function);
        }
    }

    private void generate(CdsOperation operation) {
        ClassName eventContextClassName = NamesUtils.eventContextClassName(this.configuration, null, (CdsDefinition)operation);
        ClassName handlerClassName = NamesUtils.templateEventHandlerClassName(this.configuration, operation);
        ClassName serviceWrapperClassName = NamesUtils.typedServiceBuilderName(this.configuration, this.model.getService(operation.getQualifier()));
        this.generateHandlerClass(operation, eventContextClassName, serviceWrapperClassName, handlerClassName, NamesUtils.getOnHandlerMethodName(this.configuration, operation));
    }

    private void generate(CdsEntity boundTo, CdsOperation operation) {
        ClassName eventContextClassName = NamesUtils.eventContextClassName(this.configuration, boundTo, (CdsDefinition)operation);
        ClassName handlerClassName = NamesUtils.templateEventHandlerClassName(this.configuration, boundTo, operation);
        ClassName serviceWrapperClassName = NamesUtils.typedServiceBuilderName(this.configuration, this.model.getService(boundTo.getQualifier()));
        this.generateHandlerClass(operation, eventContextClassName, serviceWrapperClassName, handlerClassName, NamesUtils.getOnHandlerMethodName(this.configuration, operation));
    }

    private void generateHandlerClass(CdsOperation operation, ClassName eventContextClassName, ClassName serviceWrapperClassName, ClassName handlerName, String methodName) {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)handlerName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Types.SPRING_BOOT_COMPONENT).addSuperinterface((TypeName)Types.EVENT_HANDLER);
        AnnotationSpec.Builder serviceName = AnnotationSpec.builder((ClassName)Types.SERVICE_NAME);
        serviceName.addMember("value", "$T.CDS_NAME", new Object[]{serviceWrapperClassName});
        builder.addAnnotation(serviceName.build());
        if (this.configuration.getDocs()) {
            operation.getDoc().ifPresent(x$0 -> builder.addJavadoc(x$0, new Object[0]));
        }
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)eventContextClassName, (String)"context", (Modifier[])new Modifier[0]).build()).addAnnotation(Types.HANDLER_ON).addComment("Your code goes here", new Object[0]).addStatement("$N.setCompleted()", new Object[]{"context"});
        builder.addMethod(methodBuilder.build());
        TypeSpec typeSpec = builder.build();
        TypeUtils.writeType(this.configuration.getHandlerPackageName(), typeSpec, this.consumer);
    }

    private boolean isRelevant(CdsDefinition definition) {
        return !TypeUtils.isIgnored((CdsAnnotatable)definition) && !this.namesUtils.isExcluded(definition.getQualifiedName());
    }
}

