/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.google.common.collect.Streams;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.TypeSpec;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.GeneratedAnnotationUtil;
import com.sap.cds.generator.util.GeneratedFile;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.util.UnSupportedModelException;
import com.sap.cds.generator.writer.CreateAppServiceInterfaceVisitor;
import com.sap.cds.generator.writer.CreateBuilderInterfaceVisitor;
import com.sap.cds.generator.writer.CreateConsumptionInterfaceVisitor;
import com.sap.cds.generator.writer.CreateEnumConstantClassVisitor;
import com.sap.cds.generator.writer.CreateEventContextInterfaceVisitor;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.generator.writer.WrapperInterfaceCreator;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsArrayedType;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEnumType;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.reflect.CdsKind;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import com.sap.cds.reflect.impl.CdsEventBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public class ModelWriter
implements CdsVisitor {
    private final GeneratedFile.Consumer consumer;
    private final Configuration config;
    private final CdsModel model;
    private final Map<String, CdsDefinition> wrapperMap;
    private final Set<String> builderInterfaces;
    private final NamesUtils namesUtils;
    private final GeneratedAnnotationUtil generated;
    private final List<String> generatedServices = new ArrayList<String>();
    private final Context context;

    public ModelWriter(GeneratedFile.Consumer consumer, Configuration config, CdsModel model) {
        this.consumer = consumer;
        this.config = config;
        this.model = model;
        this.wrapperMap = new HashMap<String, CdsDefinition>();
        this.builderInterfaces = new HashSet<String>();
        this.namesUtils = new NamesUtils(config);
        this.generated = new GeneratedAnnotationUtil(config);
        this.context = new Context((String)model.getMeta("tenantDiscriminator"), this.config, this.namesUtils);
    }

    public void visit(CdsModel model) {
        this.wrapperMap.values().forEach(this::generateWrapperInterface);
    }

    public void visit(CdsEntity entity) {
        if (!this.config.getBetterNames()) {
            NamesUtils.warnOnJavaKeywords(entity.getQualifiedName());
        }
        if (!this.namesUtils.isExcluded(entity.getQualifiedName()) && NamesUtils.isValidTechnicalEntity(this.config, this.model, entity)) {
            this.collectWrapperInterfaces((CdsDefinition)entity);
            this.generateBuilderInterface((CdsType)entity);
            this.generateConsumptionInterface((CdsType)entity);
            if (this.config.getEventContext()) {
                Streams.concat((Stream[])new Stream[]{entity.actions(), entity.functions()}).forEach(a -> this.generateEventContextInterface((CdsDefinition)a, entity));
            }
        }
    }

    public void visit(CdsEvent event) {
        if (!this.config.getBetterNames()) {
            NamesUtils.warnOnJavaKeywords(event.getQualifiedName());
        }
        if (!this.namesUtils.isExcluded(event.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)event);
            this.generateBuilderInterface((CdsType)event);
            this.generateConsumptionInterface((CdsType)event);
            if (this.config.getEventContext()) {
                this.generateEventContextInterface((CdsDefinition)event, null);
            }
        }
    }

    public void visit(CdsAction action) {
        if (this.config.getEventContext() && !this.namesUtils.isExcluded(action.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)action);
            this.generateEventContextInterface((CdsDefinition)action, null);
        }
    }

    public void visit(CdsFunction function) {
        if (this.config.getEventContext() && !this.namesUtils.isExcluded(function.getQualifiedName())) {
            this.collectWrapperInterfaces((CdsDefinition)function);
            this.generateEventContextInterface((CdsDefinition)function, null);
        }
    }

    public void visit(CdsArrayedType type) {
        if (!type.getQualifiedName().isEmpty() && type.getItemsType().isStructured() && type.getItemsType().getQualifiedName().isEmpty() && !type.getItemsType().isSimple()) {
            if (!this.config.getBetterNames()) {
                NamesUtils.warnOnJavaKeywords(type.getQualifiedName());
            }
            if (!this.namesUtils.isExcluded(type.getQualifiedName())) {
                this.generateConsumptionInterface((CdsType)type);
            }
        }
    }

    public void visit(CdsStructuredType struct) {
        if (!struct.getName().isEmpty()) {
            if (!this.config.getBetterNames()) {
                NamesUtils.warnOnJavaKeywords(struct.getQualifiedName());
            }
            if (!this.namesUtils.isExcluded(struct.getQualifiedName())) {
                this.generateConsumptionInterface((CdsType)struct);
                this.generateBuilderInterface((CdsType)struct);
                if (this.isTargetAspect(struct)) {
                    TypeUtils.logWarningForManyToManyWithStructElement(this.model, struct);
                }
            }
        }
    }

    public void visit(CdsService service) {
        if (!this.namesUtils.isExcluded(service.getQualifiedName()) && !TypeUtils.isIgnored((CdsAnnotatable)service)) {
            this.generateTypedAppServiceInterface(service);
            this.collectWrapperInterfaces((CdsDefinition)service);
        }
    }

    public void visit(CdsEnumType<?> type) {
        if (!this.namesUtils.isExcluded(type.getQualifiedName()) && !TypeUtils.isIgnored(type)) {
            TypeSpec.Builder result = TypeSpec.classBuilder((ClassName)NamesUtils.className(this.config, type)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
            result.addAnnotation(SpecWriterUtil.cdsNameAnnotation(type.getQualifiedName(), "$S"));
            type.accept((CdsVisitor)new CreateEnumConstantClassVisitor(result, this.context));
            this.generated.addTo(result);
            TypeSpec enumDefinition = result.build();
            if (!enumDefinition.fieldSpecs().isEmpty()) {
                TypeUtils.writeType(NamesUtils.packageName(this.config, type), enumDefinition, this.consumer);
            }
        }
    }

    public List<String> getGeneratedServices() {
        return this.generatedServices;
    }

    private void collectWrapperInterfaces(CdsDefinition def) {
        String string;
        if (def instanceof CdsService) {
            CdsService service = (CdsService)def;
            string = NamesUtils.packageName(this.config, service);
        } else {
            string = NamesUtils.packageName(this.config, def);
        }
        String packageName = string;
        this.wrapperMap.put(packageName, def);
    }

    private void generateWrapperInterface(CdsDefinition def) {
        ClassName className;
        String qualifiedName = def.getQualifiedName();
        String name = def.getName();
        String contextName = NamesUtils.qualifiedContextName(qualifiedName, name);
        if (def instanceof CdsService) {
            CdsService service = (CdsService)def;
            className = NamesUtils.typedServiceBuilderName(this.config, service);
        } else {
            String qualifiedWrapperName = NamesUtils.qualifiedWrapperBuilderName(def, this.config.getClassNameSuffix(), true);
            while (this.builderInterfaces.contains(qualifiedWrapperName.toLowerCase(Locale.US))) {
                qualifiedWrapperName = NamesUtils.getResolvedWrapperName(qualifiedWrapperName, this.config.getClassNameSuffix());
            }
            className = NamesUtils.wrapperInterfaceName(this.config, def, NamesUtils.unqualifiedName(qualifiedWrapperName));
        }
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((ClassName)className).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.generated.addTo(builder);
        if (new WrapperInterfaceCreator(builder, this.model, this.config).generateInterface(contextName)) {
            TypeUtils.writeType(className.packageName(), builder.build(), this.consumer);
        }
    }

    private void generateConsumptionInterface(CdsType def) {
        ClassName className = NamesUtils.className(this.config, def);
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(className);
        ModelWriter.addJavadoc(builder, (CdsDefinition)def, () -> !(def instanceof CdsEventBuilder.EventProxy) && this.config.getDocs());
        Collection parents = ((List)def.getAnnotationValue("@cds.java.extends", Collections.emptyList())).stream().map(arg_0 -> ((CdsModel)this.model).getStructuredType(arg_0)).map(this::throwErrorOnExtendEntity).collect(Collectors.toSet());
        def.accept((CdsVisitor)new CreateConsumptionInterfaceVisitor(builder, className, def.getQualifiedName(), this.context, parents));
        ((List)def.getAnnotationValue("@cds.java.extends".substring(1), Collections.emptyList())).stream().map(arg_0 -> ((CdsModel)this.model).getStructuredType(arg_0)).map(this::throwErrorOnExtendEntity).map(d -> NamesUtils.className(this.config, (CdsType)d)).forEach(arg_0 -> ((TypeSpec.Builder)builder).addSuperinterface(arg_0));
        this.generated.addTo(builder);
        TypeSpec typeSpec = builder.build();
        String packageName = NamesUtils.packageName(this.config, (CdsDefinition)def);
        TypeUtils.writeType(packageName, typeSpec, this.consumer);
    }

    private void generateEventContextInterface(CdsDefinition def, CdsEntity boundEntity) {
        if (TypeUtils.isIgnored((CdsAnnotatable)def)) {
            return;
        }
        ClassName interfaceName = NamesUtils.eventContextClassName(this.config, boundEntity, def);
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(interfaceName);
        ModelWriter.addJavadoc(builder, def, this.config::getDocs);
        Optional service = this.model.findService(boundEntity != null ? boundEntity.getQualifier() : def.getQualifier());
        boolean isRfc = service.flatMap(s -> s.findAnnotation("protocol")).map(p -> "rfc".equals(p.getValue())).orElse(false);
        Context cloned = this.context.clone(cfg -> cfg.setGroupOptionalOperationParameters(isRfc));
        String boundEntityName = boundEntity != null ? boundEntity.getQualifiedName() : null;
        def.accept((CdsVisitor)new CreateEventContextInterfaceVisitor(builder, interfaceName, boundEntityName, service.orElse(null), cloned));
        this.generated.addTo(builder);
        TypeSpec typeSpec = builder.build();
        TypeUtils.writeType(interfaceName.packageName(), typeSpec, this.consumer);
    }

    private CdsStructuredType throwErrorOnExtendEntity(CdsStructuredType struct) {
        if (struct.getKind().equals((Object)CdsKind.ENTITY) && !((CdsEntity)struct.as(CdsEntity.class)).isAbstract()) {
            throw new UnSupportedModelException("The '@cds.java.extends' annotation does not support extending an entity.");
        }
        return struct;
    }

    private void generateBuilderInterface(CdsType def) {
        ClassName builderClassName = NamesUtils.suffixedClassName(this.config, def);
        ClassName entityClassName = NamesUtils.className(this.config, def);
        TypeSpec.Builder builder = ModelWriter.createInterfaceSpecBuilder(builderClassName);
        ModelWriter.addJavadoc(builder, (CdsDefinition)def, this.config::getDocs);
        def.accept((CdsVisitor)new CreateBuilderInterfaceVisitor(builder, builderClassName, entityClassName, def.getQualifiedName(), this.context));
        this.builderInterfaces.add(NamesUtils.qualifiedWrapperBuilderName((CdsDefinition)def, this.config.getClassNameSuffix(), false).toLowerCase(Locale.US));
        this.generated.addTo(builder);
        TypeSpec typeSpec = builder.build();
        String packageName = NamesUtils.packageName(this.config, (CdsDefinition)def);
        TypeUtils.writeType(packageName, typeSpec, this.consumer);
    }

    private void generateTypedAppServiceInterface(CdsService def) {
        if (!this.config.getEventContext() || !this.config.getCqnServices()) {
            return;
        }
        ClassName interfaceName = NamesUtils.typedServiceClassName(this.config, def);
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((ClassName)interfaceName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        ModelWriter.addJavadoc(builder, (CdsDefinition)def, this.config::getDocs);
        this.generated.addTo(builder);
        def.findAnnotation("protocol").ifPresentOrElse(protocol -> def.accept((CdsVisitor)new CreateAppServiceInterfaceVisitor(builder, interfaceName, this.context.clone(cfg -> cfg.setGroupOptionalOperationParameters("rfc".equals(protocol.getValue()))))), () -> def.accept((CdsVisitor)new CreateAppServiceInterfaceVisitor(builder, interfaceName, this.context)));
        TypeSpec typeSpec = builder.build();
        TypeUtils.writeType(interfaceName.packageName(), typeSpec, this.consumer);
        this.generatedServices.add(interfaceName.canonicalName());
    }

    private static void addJavadoc(TypeSpec.Builder builder, CdsDefinition def, BooleanSupplier doRead) {
        if (doRead.getAsBoolean()) {
            SpecWriterUtil.getJavaDoc((CdsAnnotatable)def).ifPresent(a -> builder.addJavadoc(a.replace("$", "$$"), new Object[0]));
        }
    }

    private static TypeSpec.Builder createInterfaceSpecBuilder(ClassName type) {
        return TypeSpec.interfaceBuilder((ClassName)type).addModifiers(new Modifier[]{Modifier.PUBLIC});
    }

    private boolean isTargetAspect(CdsStructuredType struct) {
        return this.model.entities().flatMap(CdsStructuredType::associations).map(a -> ((CdsAssociationType)a.getType().as(CdsAssociationType.class)).getTargetAspect()).anyMatch(ta -> ta.isPresent() && ((CdsStructuredType)ta.get()).getName().equals(struct.getName()));
    }

    record Context(String tenantDiscriminator, Configuration config, NamesUtils namesUtils) {
        boolean isTenantDiscriminator(CdsElement element) {
            if (this.tenantDiscriminator == null || element == null) {
                return false;
            }
            return this.tenantDiscriminator.equals(element.getName());
        }

        public Context clone(Consumer<Configuration> consumer) {
            Configuration config = this.config.clone();
            consumer.accept(config);
            return new Context(this.tenantDiscriminator, config, this.namesUtils);
        }
    }
}

