/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.NameAllocator;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.CaseFormatHelper;
import com.sap.cds.generator.util.PatternMatcher;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEnumType;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsOperation;
import com.sap.cds.reflect.CdsParameter;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamesUtils {
    public static final String ITEM_TYPE_NAME = "Item";
    public static final String OPTIONAL_ARGS_TYPE_NAME = "OptionalArguments";
    public static final String OPTIONAL_ARGS_PARAMETER_NAME = "optionalArguments";
    private static final String CDS_MODEL = "CdsModel";
    private static final String UP = "up_";
    private static final String DOT = ".";
    private static final Logger logger = LoggerFactory.getLogger(NamesUtils.class);
    private static final String CONTEXT = "Context";
    private final List<Pattern> excludes;
    private final List<Pattern> includes;
    private static final Set<String> normalizedEventContextNames;
    private static final Set<String> normalizedMethodNames;

    public NamesUtils(Configuration config) {
        this.excludes = config.getExcludes().stream().map(PatternMatcher::transformPattern).toList();
        this.includes = config.getIncludes().stream().map(PatternMatcher::transformPattern).toList();
    }

    public static String qualifiedWrapperBuilderName(CdsDefinition def, String classNameSuffix, boolean isWrapper) {
        String name = (isWrapper ? CaseFormatHelper.toUpperCamel(NamesUtils.unqualifiedContextName(def.getQualifiedName(), def.getName())) : CaseFormatHelper.toUpperCamel(def.getName())) + classNameSuffix;
        if (def.getQualifiedName().equals(def.getName())) {
            return name;
        }
        return NamesUtils.qualifiedContextName(def.getQualifiedName(), def.getName()) + DOT + name;
    }

    public static String qualifiedContextName(String qualifiedName, String name) {
        if (name.contains(DOT)) {
            return NamesUtils.getQualifiedContextNameForDot(qualifiedName, name);
        }
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            return qualifiedName.substring(0, lastDot);
        }
        return CDS_MODEL;
    }

    static String unqualifiedContextName(String qualifiedName, String name) {
        if (name.contains(DOT)) {
            String substring = NamesUtils.getQualifiedContextNameForDot(qualifiedName, name);
            if (substring.contains(DOT)) {
                String[] bits = substring.split("\\.");
                return bits[bits.length - 1];
            }
            return substring;
        }
        if (qualifiedName.contains(DOT)) {
            String[] bits = qualifiedName.split("\\.");
            return bits[bits.length - 2];
        }
        return CDS_MODEL;
    }

    private static String getQualifiedContextNameForDot(String qualifiedName, String name) {
        String qualifiedContextName = null;
        int endIndex = qualifiedName.lastIndexOf(name) - 1;
        if (endIndex > 0) {
            qualifiedContextName = qualifiedName.substring(0, endIndex);
        }
        if (Strings.isNullOrEmpty(qualifiedContextName)) {
            return CDS_MODEL;
        }
        return qualifiedContextName;
    }

    public static String unqualifiedName(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(DOT);
        return qualifiedName.substring(lastDot + 1);
    }

    public static void warnOnJavaKeywords(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(DOT);
        if (lastDot != -1) {
            String[] split;
            for (String word : split = qualifiedName.split("\\.")) {
                if (!SourceVersion.isKeyword(word)) continue;
                logger.warn("The Entity {} contains a reserved Java keyword in its fully qualified name.", (Object)qualifiedName);
            }
        }
    }

    public static boolean isValidTechnicalEntity(Configuration configuration, CdsModel model, CdsEntity entity) {
        if (configuration.getInterfacesForAspects()) {
            if (entity.getQualifiedName().endsWith("_texts") || entity.getQualifiedName().endsWith(".texts")) {
                return true;
            }
            boolean hasUpAssociation = NamesUtils.hasUpElement(entity);
            if (hasUpAssociation) {
                String parentEntity = NamesUtils.entityParentName(entity.getQualifiedName());
                String association = NamesUtils.unqualifiedName(entity.getQualifiedName());
                Optional associationElement = model.findEntity(parentEntity).flatMap(e -> e.findElement(association));
                return associationElement.filter(e -> e.getType().isAssociation()).map(element -> {
                    Optional targetAspect = ((CdsAssociationType)element.getType().as(CdsAssociationType.class)).getTargetAspect();
                    return targetAspect.isPresent() && !((CdsStructuredType)targetAspect.get()).isAnonymous();
                }).orElse(false);
            }
            return true;
        }
        return !NamesUtils.hasUpElement(entity);
    }

    public static String getResolvedWrapperName(String qualifiedBuilderName, String classNameSuffix) {
        return qualifiedBuilderName.substring(0, qualifiedBuilderName.length() - 1) + "Model" + classNameSuffix;
    }

    public static String packageName(Configuration configuration, CdsDefinition definition) {
        String packageName = NamesUtils.prefix(definition.getQualifiedName(), definition.getName());
        return NamesUtils.getPackageName(configuration, packageName);
    }

    public static String packageName(Configuration configuration, CdsService service) {
        return NamesUtils.getPackageName(configuration, service.getQualifiedName());
    }

    public static ClassName className(Configuration configuration, CdsType type) {
        String base = NamesUtils.getJavaName((CdsAnnotatable)type, () -> ((CdsType)type).getName());
        String result = configuration.getBetterNames() ? NamesUtils.betterNameSimple(base, CaseFormatHelper::toUpperCamel) : CaseFormatHelper.toUpperCamel(base);
        return ClassName.get((String)NamesUtils.packageName(configuration, (CdsDefinition)type), (String)result, (String[])new String[0]);
    }

    public static ClassName className(Configuration configuration, ClassName parent, CdsElement element) {
        String base = NamesUtils.getJavaName((CdsAnnotatable)element, () -> ((CdsElement)element).getName());
        String result = configuration.getBetterNames() ? NamesUtils.betterNameSimple(base, CaseFormatHelper::toUpperCamel) : CaseFormatHelper.toUpperCamel(base);
        return parent.nestedClass(result);
    }

    public static ClassName className(Configuration configuration, ClassName parent, CdsParameter parameter) {
        String result = configuration.getBetterNames() ? NamesUtils.betterNameSimple(parameter.getName(), CaseFormatHelper::toUpperCamel) : CaseFormatHelper.toUpperCamel(parameter.getName());
        return parent.nestedClass(result);
    }

    public static ClassName suffixedClassName(Configuration configuration, CdsType type) {
        String base = NamesUtils.getJavaName((CdsAnnotatable)type, () -> ((CdsType)type).getName());
        String result = configuration.getBetterNames() ? NamesUtils.betterNameSimple(base, CaseFormatHelper::toUpperCamel) : CaseFormatHelper.toUpperCamel(base);
        return ClassName.get((String)NamesUtils.packageName(configuration, (CdsDefinition)type), (String)(result + configuration.getClassNameSuffix()), (String[])new String[0]);
    }

    public static ClassName suffixedClassName(Configuration configuration, ClassName parent, CdsElement element) {
        Object result = configuration.getBetterNames() ? NamesUtils.betterNameSimple(NamesUtils.getJavaName((CdsAnnotatable)element, () -> ((CdsElement)element).getName()), n -> CaseFormatHelper.toUpperCamel(n) + configuration.getClassNameSuffix()) : CaseFormatHelper.toUpperCamel(NamesUtils.getJavaName((CdsAnnotatable)element, () -> ((CdsElement)element).getName())) + configuration.getClassNameSuffix();
        return parent.nestedClass((String)result);
    }

    public static ClassName typedServiceClassName(Configuration configuration, CdsService service) {
        String packageName = NamesUtils.packageName(configuration, service);
        String name = configuration.getBetterNames() ? NamesUtils.betterNameSimple(NamesUtils.getJavaName((CdsAnnotatable)service, () -> ((CdsService)service).getName()), CaseFormatHelper::toUpperCamel) : CaseFormatHelper.toUpperCamel(NamesUtils.getJavaName((CdsAnnotatable)service, () -> ((CdsService)service).getName()));
        return ClassName.get((String)packageName, (String)name, (String[])new String[0]);
    }

    public static ClassName typedServiceBuilderName(Configuration configuration, CdsService service) {
        String packageName = NamesUtils.packageName(configuration, service);
        Object name = NamesUtils.getJavaName((CdsAnnotatable)service, () -> ((CdsService)service).getName());
        name = configuration.getBetterNames() ? NamesUtils.betterNameSimple((String)name, n -> CaseFormatHelper.toUpperCamel(n) + configuration.getClassNameSuffix()) : CaseFormatHelper.toUpperCamel((String)name) + configuration.getClassNameSuffix();
        return ClassName.get((String)packageName, (String)name, (String[])new String[0]);
    }

    public static ClassName templateEventHandlerClassName(Configuration configuration, CdsOperation operation) {
        String operationName = NamesUtils.getJavaName((CdsAnnotatable)operation, () -> ((CdsOperation)operation).getName());
        String handlerName = "%1$s_%2$s_handler".formatted(NamesUtils.unqualifiedName(operation.getQualifier()), operationName);
        String result = configuration.getBetterNames() ? NamesUtils.betterNameSimple(handlerName, CaseFormatHelper::toUpperCamel) : CaseFormatHelper.toUpperCamel(handlerName);
        return ClassName.get((String)configuration.getHandlerPackageName(), (String)result, (String[])new String[0]);
    }

    public static ClassName templateEventHandlerClassName(Configuration configuration, CdsEntity entity, CdsOperation operation) {
        String operationName = NamesUtils.getJavaName((CdsAnnotatable)operation, () -> ((CdsOperation)operation).getName());
        ClassName entityClassName = NamesUtils.className(configuration, (CdsType)entity);
        String handlerName = "%1$s_%2$s_%3$s_handler".formatted(NamesUtils.unqualifiedName(entity.getQualifier()), entityClassName.simpleName(), operationName);
        String result = configuration.getBetterNames() ? NamesUtils.betterNameSimple(handlerName, CaseFormatHelper::toUpperCamel) : CaseFormatHelper.toUpperCamel(handlerName);
        return ClassName.get((String)configuration.getHandlerPackageName(), (String)result, (String[])new String[0]);
    }

    public static ClassName wrapperInterfaceName(Configuration configuration, CdsDefinition definition, String suggestion) {
        String packageName = NamesUtils.packageName(configuration, definition);
        String name = configuration.getBetterNames() ? NamesUtils.betterNameSimple(suggestion, n -> CaseFormatHelper.toUpperCamel(n) + configuration.getClassNameSuffix()) : suggestion;
        return ClassName.get((String)packageName, (String)name, (String[])new String[0]);
    }

    public static String getOnHandlerMethodName(Configuration configuration, CdsOperation operation) {
        String base = NamesUtils.getJavaName((CdsAnnotatable)operation, () -> ((CdsOperation)operation).getName());
        if (configuration.getBetterNames()) {
            String name = NamesUtils.betterNameSimple(base, CaseFormatHelper::toUpperCamel);
            return "handle" + name;
        }
        return "handle" + CaseFormatHelper.toUpperCamel(base);
    }

    public static ClassName eventContextClassName(Configuration configuration, CdsEntity boundEntity, CdsDefinition def) {
        String packageName = boundEntity != null ? NamesUtils.packageName(configuration, (CdsDefinition)boundEntity) : NamesUtils.packageName(configuration, def);
        Optional<String> annotation = def.findAnnotation("@cds.java.this.name").or(() -> def.findAnnotation("@cds.java.name")).map(a -> (String)a.getValue());
        if (annotation.isPresent()) {
            String className = NamesUtils.contextName(configuration, annotation.get());
            return ClassName.get((String)packageName, (String)className, (String[])new String[0]);
        }
        String ownName = NamesUtils.contextName(configuration, def.getName());
        if (boundEntity != null) {
            ClassName prefix = NamesUtils.className(configuration, (CdsType)boundEntity);
            return ClassName.get((String)packageName, (String)(prefix.simpleName() + ownName), (String[])new String[0]);
        }
        return ClassName.get((String)packageName, (String)ownName, (String[])new String[0]);
    }

    private static String contextName(Configuration configuration, String value) {
        if (configuration.getBetterNames()) {
            return NamesUtils.betterNameSimple(value + CONTEXT, CaseFormatHelper::toUpperCamel);
        }
        return CaseFormatHelper.toUpperCamel(value + CONTEXT);
    }

    public static String methodName(Configuration configuration, CdsElement element) {
        String method = NamesUtils.methodNameImpl(configuration, element);
        return NamesUtils.avoidMethodClash(method);
    }

    private static String methodNameImpl(Configuration configuration, CdsElement element) {
        String base = NamesUtils.elementName((CdsAnnotatable)element, () -> ((CdsElement)element).getName());
        if (configuration.getBetterNames()) {
            return NamesUtils.betterNameWithUnderscore(base, CaseFormatHelper::toLowerCamel);
        }
        return CaseFormatHelper.toLowerCamel(base);
    }

    public static String rawName(Configuration configuration, CdsElement element) {
        String base = NamesUtils.elementName((CdsAnnotatable)element, () -> ((CdsElement)element).getName());
        if (configuration.getBetterNames()) {
            base = NamesUtils.betterNameSimple(base, UnaryOperator.identity());
        }
        return NamesUtils.avoidMethodClash(base);
    }

    public static String methodName(Configuration configuration, CdsParameter parameter) {
        String methodName = NamesUtils.methodNameImpl(configuration, parameter);
        return NamesUtils.avoidMethodClash(methodName);
    }

    public static String methodName(Configuration configuration, CdsOperation operation) {
        String name = configuration.getBetterNames() ? NamesUtils.betterNameSimple(NamesUtils.getJavaName((CdsAnnotatable)operation, () -> ((CdsOperation)operation).getName()), UnaryOperator.identity()) : NamesUtils.getJavaName((CdsAnnotatable)operation, () -> ((CdsOperation)operation).getName()).replace('.', '_');
        return name;
    }

    public static String setterName(Configuration configuration, CdsElement element) {
        String result = NamesUtils.baseMethodNamePart(configuration, NamesUtils.elementName((CdsAnnotatable)element, () -> ((CdsElement)element).getName()));
        return "set" + result;
    }

    public static String getterName(Configuration configuration, CdsElement element) {
        String result = NamesUtils.baseMethodNamePart(configuration, NamesUtils.elementName((CdsAnnotatable)element, () -> ((CdsElement)element).getName()));
        return "get" + NamesUtils.avoidMethodClash(result);
    }

    public static String setterName(Configuration configuration, CdsParameter parameter) {
        String result = NamesUtils.baseMethodNamePart(configuration, NamesUtils.elementName((CdsAnnotatable)parameter, () -> ((CdsParameter)parameter).getName()));
        return "set" + NamesUtils.avoidEventContextClash(result);
    }

    public static String getterName(Configuration configuration, CdsParameter parameter) {
        String result = NamesUtils.baseMethodNamePart(configuration, NamesUtils.elementName((CdsAnnotatable)parameter, () -> ((CdsParameter)parameter).getName()));
        return "get" + NamesUtils.avoidEventContextClash(result);
    }

    public static String argumentName(Configuration configuration, CdsElement element) {
        return NamesUtils.methodNameImpl(configuration, element);
    }

    public static String argumentName(Configuration configuration, CdsParameter parameter) {
        return NamesUtils.methodNameImpl(configuration, parameter);
    }

    public static String constantNameForWrapperInterface(Configuration configuration, CdsDefinition definition) {
        if (configuration.getBetterNames()) {
            return NamesUtils.betterNameSimple(definition.getName(), n -> CaseFormatHelper.toUpperUnderscore(CaseFormatHelper.toUpperCamel(n)));
        }
        return CaseFormatHelper.toUpperUnderscore(CaseFormatHelper.toUpperCamel(definition.getName()));
    }

    public static String constantName(Configuration configuration, CdsElement element) {
        String name = NamesUtils.elementName((CdsAnnotatable)element, () -> ((CdsElement)element).getName());
        if (configuration.getBetterNames()) {
            return NamesUtils.betterNameWithUnderscore(name, CaseFormatHelper::toUpperUnderscore);
        }
        return CaseFormatHelper.toUpperUnderscore(name);
    }

    public static String constantName(Configuration configuration, CdsParameter parameter) {
        return NamesUtils.constantName(configuration, parameter.getName());
    }

    public static String constantName(Configuration configuration, String value) {
        if (configuration.getBetterNames()) {
            return NamesUtils.betterNameWithUnderscore(value, CaseFormatHelper::toUpperUnderscore);
        }
        return CaseFormatHelper.toUpperUnderscore(value);
    }

    public static String constantName(Configuration configuration, CdsEnumType.Enumeral<?> enumeral) {
        String name = NamesUtils.getJavaName(enumeral, () -> enumeral.name());
        if (configuration.getBetterNames()) {
            return NamesUtils.betterNameSimple(name, CaseFormatHelper::toUpperUnderscore);
        }
        if (SourceVersion.isName(name)) {
            return CaseFormatHelper.toUpperUnderscore(name);
        }
        return "_" + CaseFormatHelper.toUpperUnderscore(NameAllocator.toJavaIdentifier((String)name));
    }

    private static String elementName(CdsAnnotatable element, Supplier<String> defaultValue) {
        Optional cdsJavaName = Optional.empty();
        if (element.findAnnotation("@odata.foreignKey4").isEmpty()) {
            cdsJavaName = element.findAnnotation("@cds.java.name");
        }
        return cdsJavaName.map(CdsAnnotation::getValue).orElse(defaultValue.get());
    }

    private static String getJavaName(CdsAnnotatable definition, Supplier<String> defaultNameSupplier) {
        return definition.findAnnotation("@cds.java.this.name").or(() -> definition.findAnnotation("@cds.java.name")).map(a -> (String)a.getValue()).orElseGet(defaultNameSupplier);
    }

    @VisibleForTesting
    static String prefix(String qualifiedName, String name) {
        if (qualifiedName.equals(name)) {
            return null;
        }
        return qualifiedName.substring(0, qualifiedName.lastIndexOf(name) - 1);
    }

    private static String entityParentName(String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot != -1) {
            return qualifiedName.substring(0, lastDot);
        }
        return null;
    }

    private static String javaSafeName(String name) {
        String[] parts = name.split("\\.");
        if (parts.length == 0) {
            return SourceVersion.isKeyword(name) ? name + "_" : name;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            part = NameAllocator.toJavaIdentifier((String)part);
            sb.append(part);
            if (SourceVersion.isKeyword(part)) {
                sb.append("_");
            }
            sb.append(DOT);
        }
        String lastPart = parts[parts.length - 1];
        lastPart = NameAllocator.toJavaIdentifier((String)lastPart);
        sb.append(lastPart);
        if (SourceVersion.isKeyword(lastPart)) {
            sb.append("_");
        }
        return sb.toString();
    }

    private static String getPackageName(Configuration configuration, String packageName) {
        boolean betterNames;
        String basePackage = configuration != null ? configuration.getBasePackage() : null;
        boolean bl = betterNames = configuration != null && configuration.getBetterNames();
        if (!Strings.isNullOrEmpty((String)basePackage)) {
            packageName = Joiner.on((char)'.').skipNulls().join((Object)basePackage, (Object)packageName, new Object[0]);
        }
        if (Strings.isNullOrEmpty((String)packageName)) {
            packageName = "model";
        }
        if (betterNames) {
            String result = CaseFormatHelper.normalizeWhiteSpaceInPath(packageName.toLowerCase(Locale.US));
            return NamesUtils.javaSafeName(result);
        }
        return packageName.toLowerCase(Locale.US);
    }

    private static boolean matchesAny(String qualifiedName, List<Pattern> patternList) {
        return patternList.stream().anyMatch(pm -> pm.matcher(qualifiedName).matches());
    }

    private static boolean hasUpElement(CdsEntity entity) {
        return entity.elements().anyMatch(e -> e.getName().startsWith(UP) && e.getType().isAssociation() && e.isKey());
    }

    public boolean isExcluded(String qualifiedName) {
        boolean included = this.includes.isEmpty() || NamesUtils.matchesAny(qualifiedName, this.includes);
        return !(included &= !NamesUtils.matchesAny(qualifiedName, this.excludes));
    }

    private static String betterNameSimple(String from, UnaryOperator<String> converter) {
        String result = (String)converter.apply(CaseFormatHelper.normalizeWhitespaceInIdentifier(from));
        result = NamesUtils.javaSafeName(result);
        return result;
    }

    private static String betterNameWithUnderscore(String from, UnaryOperator<String> converter) {
        Object result = from.startsWith("_") ? "_" + (String)converter.apply(CaseFormatHelper.normalizeWhitespaceInIdentifier(from)) : (String)converter.apply(CaseFormatHelper.normalizeWhitespaceInIdentifier(from));
        result = NamesUtils.javaSafeName((String)result);
        return result;
    }

    private static String avoidMethodClash(String name) {
        if (normalizedMethodNames.contains(name)) {
            return name + "_";
        }
        return name;
    }

    private static String avoidEventContextClash(String name) {
        if (normalizedEventContextNames.contains(name)) {
            return name + "_";
        }
        return name;
    }

    private static String methodNameImpl(Configuration configuration, CdsParameter parameter) {
        if (configuration.getBetterNames()) {
            return NamesUtils.betterNameWithUnderscore(NamesUtils.elementName((CdsAnnotatable)parameter, () -> ((CdsParameter)parameter).getName()), CaseFormatHelper::toLowerCamel);
        }
        return CaseFormatHelper.toLowerCamel(NamesUtils.elementName((CdsAnnotatable)parameter, () -> ((CdsParameter)parameter).getName()));
    }

    private static String baseMethodNamePart(Configuration configuration, String source) {
        if (configuration.getBetterNames()) {
            return NamesUtils.betterNameWithUnderscore(source, CaseFormatHelper::toUpperCamel);
        }
        return CaseFormatHelper.toUpperCamel(source);
    }

    static {
        normalizedMethodNames = new HashSet<String>();
        normalizedMethodNames.add("isForRemoval");
        normalizedMethodNames.add("hashCode");
        normalizedMethodNames.add("isCompleted");
        normalizedMethodNames.add("wait");
        normalizedMethodNames.add("notify");
        normalizedMethodNames.add("Class");
        normalizedEventContextNames = new HashSet<String>();
        normalizedEventContextNames.add("Model");
        normalizedEventContextNames.add("Messages");
        normalizedEventContextNames.add("Service");
        normalizedEventContextNames.add("Event");
        normalizedEventContextNames.add("Target");
        normalizedEventContextNames.addAll(normalizedMethodNames);
    }
}

