/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.generator.writer;

import com.palantir.javapoet.AnnotationSpec;
import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.FieldSpec;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.ParameterizedTypeName;
import com.palantir.javapoet.TypeName;
import com.palantir.javapoet.TypeSpec;
import com.palantir.javapoet.WildcardTypeName;
import com.sap.cds.generator.Configuration;
import com.sap.cds.generator.util.NamesUtils;
import com.sap.cds.generator.util.TypeUtils;
import com.sap.cds.generator.writer.ModelWriter;
import com.sap.cds.generator.writer.SpecWriterUtil;
import com.sap.cds.generator.writer.Types;
import com.sap.cds.ql.CdsName;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsEvent;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.CdsVisitor;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateBuilderInterfaceVisitor
implements CdsVisitor {
    private static final Logger logger = LoggerFactory.getLogger(CreateBuilderInterfaceVisitor.class);
    private static final String FILTER = "filter";
    private final TypeSpec.Builder entityClass;
    private final Configuration cfg;
    private final ClassName builderClassName;
    private final ClassName entityClassName;
    private final String qualifiedCdsName;
    private final ModelWriter.Context context;

    CreateBuilderInterfaceVisitor(TypeSpec.Builder builder, ClassName builderClassName, ClassName entityClassName, String qualifiedCdsName, ModelWriter.Context context) {
        this.entityClass = builder;
        this.context = context;
        this.cfg = context.config();
        this.builderClassName = builderClassName;
        this.entityClassName = entityClassName;
        this.qualifiedCdsName = qualifiedCdsName;
    }

    public void visit(CdsEntity entity) {
        this.generateInterface();
    }

    public void visit(CdsEvent event) {
        this.generateInterface();
    }

    public void visit(CdsStructuredType struct) {
        this.generateInterface();
    }

    public void visit(CdsElement attribute) {
        if (this.context.isTenantDiscriminator(attribute)) {
            return;
        }
        CdsType type = attribute.getType();
        if (type.isStructured() || type.isSimpleType(CdsBaseType.MAP)) {
            this.addStructuredAttribute(attribute);
        } else if (type.isAssociation()) {
            this.addAssociationAttribute(attribute);
        } else {
            this.addAttribute(attribute);
        }
    }

    private void generateInterface() {
        this.entityClass.addSuperinterface(this.getBuilderInterfaceBase((TypeName)this.builderClassName, (TypeName)this.entityClassName, this.context));
        if (this.qualifiedCdsName != null) {
            this.entityClass.addAnnotation(AnnotationSpec.builder(CdsName.class).addMember("value", "$S", new Object[]{this.qualifiedCdsName}).build());
            FieldSpec staticField = FieldSpec.builder(String.class, (String)"CDS_NAME", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$S", new Object[]{this.qualifiedCdsName}).build();
            this.entityClass.addField(staticField);
        }
    }

    private ClassName addInnerInterface(CdsElement parentElement, Stream<CdsElement> elements) {
        ClassName innerInterfaceName = NamesUtils.suffixedClassName(this.cfg, this.builderClassName, parentElement);
        ClassName innerEntityClassName = NamesUtils.className(this.cfg, this.entityClassName, parentElement);
        String innerQualifiedCdsName = parentElement.getType().isAssociation() && this.qualifiedCdsName != null ? this.qualifiedCdsName + "." + parentElement.getName() : null;
        TypeSpec.Builder innerInterfaceBuilder = TypeSpec.interfaceBuilder((ClassName)innerInterfaceName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC});
        CreateBuilderInterfaceVisitor innerVisitor = new CreateBuilderInterfaceVisitor(innerInterfaceBuilder, innerInterfaceName, innerEntityClassName, innerQualifiedCdsName, this.context);
        elements.forEach(e -> e.accept((CdsVisitor)innerVisitor));
        innerVisitor.generateInterface();
        this.entityClass.addType(innerInterfaceBuilder.build());
        return innerInterfaceName;
    }

    private void addStructuredAttribute(CdsElement attribute) {
        if (!TypeUtils.isIgnored((CdsAnnotatable)attribute)) {
            ParameterizedTypeName returnType;
            if (attribute.getType().isSimpleType(CdsBaseType.MAP)) {
                returnType = ParameterizedTypeName.get((ClassName)ClassName.get(StructuredType.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)});
            } else if (((CdsStructuredType)attribute.getType().as(CdsStructuredType.class)).isAnonymous()) {
                Stream elements = ((CdsStructuredType)attribute.getType().as(CdsStructuredType.class)).elements();
                returnType = this.addInnerInterface(attribute, elements);
            } else {
                returnType = NamesUtils.suffixedClassName(this.cfg, (CdsType)attribute.getType().as(CdsStructuredType.class));
            }
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)NamesUtils.methodName(this.cfg, attribute)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)returnType);
            if (SpecWriterUtil.addCdsNameAnnotation(this.cfg, methodBuilder, attribute)) {
                SpecWriterUtil.addStaticField(this.context.config(), this.entityClass, attribute);
            }
            this.entityClass.addMethod(methodBuilder.build());
        }
    }

    private void addAssociationAttribute(CdsElement attribute) {
        if (TypeUtils.isAnonymousAspect(attribute)) {
            this.addInnerInterface(attribute, TypeUtils.getAnonymousElements(attribute));
        }
        this.addMainFunction(attribute);
        this.addFilterFunction(attribute);
    }

    private void addAttribute(CdsElement attribute) {
        if (!TypeUtils.isIgnored((CdsAnnotatable)attribute)) {
            ParameterizedTypeName returnType = ParameterizedTypeName.get((ClassName)Types.REFERENCE, (TypeName[])new TypeName[]{TypeUtils.getReturnType(this.entityClassName, attribute, this.cfg)});
            String name = NamesUtils.rawName(this.context.config(), attribute);
            MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)returnType);
            if (SpecWriterUtil.addCdsNameAnnotation(this.cfg, methodBuilder, attribute)) {
                SpecWriterUtil.addStaticField(this.context.config(), this.entityClass, attribute);
            }
            this.entityClass.addMethod(methodBuilder.build());
        }
    }

    private void addMainFunction(CdsElement attribute) {
        ClassName returnType = this.getTargetName(attribute);
        if (!TypeUtils.isIgnored((CdsAnnotatable)attribute)) {
            String name = NamesUtils.rawName(this.context.config(), attribute);
            this.entityClass.addMethod(MethodSpec.methodBuilder((String)name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)returnType).build());
        } else {
            logger.error("Unable to generate method %s for %s".formatted(attribute.getName(), returnType));
        }
    }

    private void addFilterFunction(CdsElement attribute) {
        if (!attribute.getName().equalsIgnoreCase(FILTER)) {
            ClassName returnType = this.getTargetName(attribute);
            if (!TypeUtils.isIgnored((CdsAnnotatable)attribute)) {
                String name = NamesUtils.rawName(this.context.config(), attribute);
                this.entityClass.addMethod(MethodSpec.methodBuilder((String)name).addParameter((TypeName)ParameterizedTypeName.get((ClassName)Types.FUNCTION, (TypeName[])new TypeName[]{returnType, Types.PREDICATE}), FILTER, new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)returnType).build());
            } else {
                logger.error("Unable to generate filter method %s for %s".formatted(attribute.getName(), returnType));
            }
        } else {
            logger.warn("There is a name clash between the element 'filter' of entity '%s' and a method in the super interface StructuredType. A filter function accepting predicates will not be generated.\n".formatted(this.builderClassName.simpleName()));
        }
    }

    public ClassName getTargetName(CdsElement element) {
        CdsAssociationType association = (CdsAssociationType)element.getType();
        CdsType target = (CdsType)association.getTargetAspect().orElseGet(() -> ((CdsAssociationType)association).getTarget());
        if (target.getQualifiedName().isEmpty()) {
            return NamesUtils.suffixedClassName(this.cfg, this.builderClassName, element);
        }
        return NamesUtils.suffixedClassName(this.cfg, target);
    }

    private TypeName getBuilderInterfaceBase(TypeName builderClass, TypeName pojoClass, ModelWriter.Context context) {
        if (context.config().getLinkedInterfaces()) {
            return ParameterizedTypeName.get((ClassName)Types.LINKED_STRUCTURED_TYPE, (TypeName[])new TypeName[]{pojoClass, builderClass});
        }
        return ParameterizedTypeName.get((ClassName)Types.STRUCTURED_TYPE, (TypeName[])new TypeName[]{builderClass});
    }
}

