/*******************************************************************
 * © 2020 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.spi;

import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnLock;
import com.sap.cds.ql.cqn.CqnStatement;

@Beta
public interface StatementResolver {

	Stream<String> timeout(Optional<CqnLock> lock);

	default Optional<String> collateClause(Locale locale) {
		return Optional.empty();
	}

	default Optional<String> collateClause(CqnStatement statement, Locale locale) {
		return collateClause(locale);
	}
}
