/************************************************************************
 * © 2021-2022 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.spi;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.UnaryOperator;

import com.google.common.annotations.Beta;
import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsModel;

@Beta
public interface DbContext {

	TableNameResolver createTableNameResolver(Locale locale);

	SearchResolver createSearchResolver(CdsModel model, Locale locale);

	FunctionMapper getFunctionMapper();

	StatementResolver getStatementResolver();

	ExceptionAnalyzer getExceptionAnalyzer();

	Capabilities getCapabilities();

	UnaryOperator<CqnPredicate> getPredicateMapper();

	ValueBinder getBinder(TimeZone timeZone);
	
	SessionVariableSetter getSessionVariableSetter();

}
