/************************************************************************
 * © 2020-2022 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.spi;

import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

import com.google.common.annotations.Beta;
import com.sap.cds.ql.cqn.CqnLock.Mode;
import com.sap.cds.ql.cqn.CqnStatement;

@Beta
public interface StatementResolver {

	default Optional<String> timeoutClause(int timeoutSeconds) {
		return Optional.empty();
	}

	default Optional<String> collateClause(Locale locale) {
		return Optional.empty();
	}

	default Optional<String> collateClause(CqnStatement statement, Locale locale) {
		return collateClause(locale);
	}

	default String upsert(String table, Stream<String> keyColumns, Stream<String> upsertColumns,
			Stream<String> upsertValues) {
		throw new UnsupportedOperationException("Upsert is not supported on this data store");
	}

	default Optional<String> lockClause(Mode mode) {
		return Optional.of("FOR UPDATE");
	}

	default Optional<String> hints(Map<String, Object> hints) {
		return Optional.empty();
	}
}
